/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v30;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.v34.Starcos34Tools;

public class CardProduct
extends CiCardProduct {
    private int cardType = 0;

    public void accepted(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        super.accepted(factory, connection);
        try {
            byte[] serial = Starcos34Tools.getSerialNumber((ICardProduct)this, connection);
            if (serial.length >= 6) {
                this.cardType = (serial[4] & 0xF) + ((serial[5] & 0xF0) >> 4);
            }
        }
        catch (CardApplicationException e) {
            this.cardType = 1;
        }
    }

    protected int createGlobalRestriction(ICardConnection connection) throws CardApplicationException {
        IPinInfo pinInfo = this.getCardInfo().lookupPinInfo("PIN.CH");
        if (pinInfo == null) {
            return 1;
        }
        return Starcos34Tools.getSecurityStatusEvaluationCounter((ICardProduct)this, connection, pinInfo);
    }

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        IPinInfo pinInfo = this.getCardInfo().lookupPinInfo("PIN.QES");
        if (pinInfo == null) {
            return 1;
        }
        return Starcos34Tools.getSecurityStatusEvaluationCounter((ICardProduct)this, connection, pinInfo);
    }

    public int getCardType() {
        return this.cardType;
    }

    public boolean isAdvanced() {
        return this.getCardType() == 1;
    }

    public boolean isBatch() {
        return this.getCardType() == 4;
    }

    public boolean isMulti() {
        return this.getCardType() == 3;
    }

    public boolean isStandard() {
        return this.getCardType() == 2;
    }
}

