/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v30;

import de.intarsys.security.smartcard.app.common.AbstractCardStateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.v34.Starcos34Tools;
import de.intarsys.security.smartcard.pkcs15.CardInfo;
import de.intarsys.security.smartcard.pkcs15.PKCS15Tools;
import de.intarsys.tools.hex.HexTools;

public class CardStateApp
extends AbstractCardStateApp {
    public String getLabel() throws CardApplicationException {
        IFileSystemApplication fileSystem = this.getFileSystem();
        try {
            CardInfo tokenInfo;
            CardFileSelector selector = this.getCardInfo().lookupFileSelector("EF.TOKEN");
            if (selector != null && (tokenInfo = PKCS15Tools.getTokenInfo((IFileSystemApplication)fileSystem, (CardFileSelector)selector)) != null) {
                String label = tokenInfo.getLabel();
                label = label.substring(0, label.length() - 1);
                return label;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getLabel();
    }

    public String getSerialNumber() throws CardApplicationException {
        byte[] serial = Starcos34Tools.getSerialNumber(this.getCardProduct(), this.getCardConnection());
        if (serial.length > 0) {
            return HexTools.bytesToHexString((byte[])serial);
        }
        return "00";
    }
}

