/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v30;

import de.intarsys.security.smartcard.app.common.AbstractPinStateApp;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateActive;
import de.intarsys.security.smartcard.common.PinStateLocked;
import de.intarsys.security.smartcard.common.PinStateNotAvailable;
import de.intarsys.security.smartcard.common.PinStateTransport;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;

public class PinStateApp
extends AbstractPinStateApp {
    public PinState getPinState(IPinInfo pinInfo) throws CardApplicationException {
        if (pinInfo.isResetPinInfo()) {
            return new PinStateActive(pinInfo, -1);
        }
        try {
            this.getFileSystem().selectDf(pinInfo.getDirectory(), false);
        }
        catch (Exception e) {
            return new PinStateNotAvailable(pinInfo);
        }
        RequestAPDU request = new RequestAPDU(128, 32, 0, pinInfo.getReference());
        request.setLabel("DTrust get PIN status, pin " + pinInfo.getReference());
        ResponseAPDU resp = this.transmit(request);
        int sw1 = resp.getSw1();
        int sw2 = resp.getSw2();
        if (sw1 == 98) {
            if (sw2 == 193) {
                return new PinStateTransport(pinInfo);
            }
        } else if (sw1 == 105) {
            if (sw2 == 132) {
                return new PinStateTransport(pinInfo);
            }
        } else if (sw1 == 99) {
            if (sw2 == 0) {
                return new PinStateLocked(pinInfo);
            }
            if ((sw2 & 0xF0) == 192) {
                int retries = sw2 & 0xF;
                if (retries == 0) {
                    return new PinStateLocked(pinInfo);
                }
                return new PinStateActive(pinInfo, retries);
            }
        }
        return new PinStateUnknown(pinInfo);
    }
}

