/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v31;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.PinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.security.smartcard.pkcs15.PrivateKeyObject;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;

public class CardProduct
extends Pkcs15CardProduct {
    @Override
    public void accepted(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        PinInfo piSignaturePUK;
        PinInfo piSignaturePIN;
        super.accepted(factory, connection);
        PinInfo piCardPIN = (PinInfo)this.getCardInfo().lookupPinInfo("PIN.@11");
        PinInfo piCardPUK = (PinInfo)this.getCardInfo().lookupPinInfo("PIN.@1A");
        if (piCardPUK != null) {
            piCardPUK.setFixed(true);
        }
        if ((piSignaturePIN = (PinInfo)this.getCardInfo().lookupPinInfo("PIN.@01")) != null) {
            piSignaturePIN.setTransportLength(5);
            piSignaturePIN.setReference(129);
        }
        if ((piSignaturePUK = (PinInfo)this.getCardInfo().lookupPinInfo("PIN.@0A")) != null) {
            piSignaturePUK.setReference(138);
            piSignaturePUK.setFixed(true);
            piSignaturePUK.setResetRetryCounterOnly(true);
        }
    }

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        Pkcs15Structure pkcs15 = this.getPkcs15Structure();
        PrivateKeyObject pko = (PrivateKeyObject)pkcs15.getP15PrivateKeyObjectDirectory().getObject(new byte[]{18});
        if (pko == null) {
            return 1;
        }
        if (pko.getCommonObjectAttributes().getUserConsent() == null) {
            return -1;
        }
        return pko.getCommonObjectAttributes().getUserConsent().intValue();
    }
}

