/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v34;

import de.intarsys.security.smartcard.app.common.AbstractSignApp;
import de.intarsys.security.smartcard.app.common.IAdvSignApplication;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICommand;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.Mechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.cmd.ICmdPerformSecurityOperation;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import jakarta.annotation.PostConstruct;

public class QSignApp
extends AbstractSignApp
implements IQSignApplication,
IAdvSignApplication {
    private Mechanism mechanism;

    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        IMechanism mechanism = this.detectMechanism();
        if (mechanism == null) {
            throw new CardApplicationException("no mechanism found for " + this.getHashAlgorithmName());
        }
        this.cmdMseRestore(9);
        byte[] psoData = this.createPSOInput(data, mechanism);
        return this.cmdPsoComputeDigitalSignature(psoData).getData();
    }

    protected ResponseAPDU cmdPsoComputeDigitalSignature(byte[] message) throws CardApplicationException {
        ICmdPerformSecurityOperation pso = (ICmdPerformSecurityOperation)this.getCommand(ICmdPerformSecurityOperation.class);
        RequestAPDU req = pso.createComputeDigitalSignature(message);
        req.setExtendedApdu(true);
        return this.sendRequest((ICommand)pso, req);
    }

    protected IMechanism detectMechanism() throws CardApplicationException {
        return this.getMechanism();
    }

    protected CardFileSelector getAuthenticationPath() {
        return this.getCardHolderCertificate().getPrivateKeyInfo().getDirectory();
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IQSignApplication.class;
    }

    protected CardFileSelector getDefaultApplicationPath() {
        Pkcs15CardProduct cardProduct = (Pkcs15CardProduct)this.getCardProduct();
        return cardProduct.getApplicationPath();
    }

    protected Mechanism getMechanism() {
        return this.mechanism;
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        this.setRestrictionCount(this.getCardProduct().getQSigRestriction(this.getCardConnection()));
        super.initialize();
        this.setSupportedHashAlgorithmNames(DIGEST_ALGORITHMS_SHA256);
        Mechanism tmpMech = new Mechanism();
        tmpMech.setHashAlgorithmNames("SHA256");
        tmpMech.setId("dst");
        tmpMech.setOperation("DST");
        tmpMech.setInputEncodingAlgorithmName("Raw");
        tmpMech.setOutputEncodingAlgorithmName("PSS");
        this.setMechanism(tmpMech);
    }

    protected void setMechanism(Mechanism mechanism) {
        this.mechanism = mechanism;
    }
}

