/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v41;

import de.intarsys.security.smartcard.app.common.GenericAdvSignApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.Mechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;

public class AdvSignApp
extends GenericAdvSignApp {
    protected IMechanism detectMechanism() throws CardApplicationException {
        String encryptionAlgorithmName = this.getEncryptionAlgorithmName();
        if ("RSA".equals(encryptionAlgorithmName)) {
            Mechanism tmpMech = new Mechanism();
            tmpMech.setHashAlgorithmNames("SHA256");
            tmpMech.setId("dst");
            tmpMech.setOperation("DST");
            tmpMech.setInputEncodingAlgorithmName("DigestInfo");
            tmpMech.setOutputEncodingAlgorithmName(null);
            tmpMech.setSecurityEnvironment(37);
            return tmpMech;
        }
        if ("ECDSA".equals(encryptionAlgorithmName)) {
            Mechanism tmpMech = new Mechanism();
            tmpMech.setHashAlgorithmNames("SHA256");
            tmpMech.setId("dst");
            tmpMech.setOperation("DST");
            tmpMech.setSecurityEnvironment(33);
            return tmpMech;
        }
        return null;
    }

    protected CardFileSelector getAuthenticationPath() {
        return this.getCardHolderCertificate().getPrivateKeyInfo().getDirectory();
    }

    protected CardFileSelector getDefaultApplicationPath() {
        Pkcs15CardProduct cardProduct = (Pkcs15CardProduct)this.getCardProduct();
        return cardProduct.getApplicationPath();
    }
}

