/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v41;

import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.PinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;

public class CardProduct
extends Pkcs15CardProduct {
    @Override
    public void accepted(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        PinInfo piSignaturePIN;
        PinInfo piCardPUK;
        super.accepted(factory, connection);
        PinInfo piCardPIN = (PinInfo)this.getCardInfo().lookupPinInfo("PIN.@03");
        if (piCardPIN != null) {
            piCardPIN.setDirectory((CardFileSelector)CardFilePath.ROOT);
        }
        if ((piCardPUK = (PinInfo)this.getCardInfo().lookupPinInfo("PIN.@04")) != null) {
            piCardPUK.setDirectory((CardFileSelector)CardFilePath.ROOT);
            piCardPUK.setFixed(true);
            piCardPUK.setResetRetryCounterOnly(true);
        }
        if ((piSignaturePIN = (PinInfo)this.getCardInfo().lookupPinInfo("PIN.@02")) == null) {
            piSignaturePIN = (PinInfo)this.getCardInfo().lookupPinInfo("PIN.@07");
        }
        if (piSignaturePIN != null) {
            piSignaturePIN.setTransportLength(5);
        }
    }

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        Pkcs15Structure pkcs15 = this.getPkcs15Structure();
        String label = pkcs15.getP15TokenInfo().getLabel();
        if (label == null) {
            return 1;
        }
        if (label.contains("Std.")) {
            return 1;
        }
        if (label.contains("Multi")) {
            return -1;
        }
        if (label.contains("M100")) {
            return 100;
        }
        return 1;
    }
}

