/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v44;

import de.intarsys.security.smartcard.app.common.GenericQSignApp;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.Mechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import jakarta.annotation.PostConstruct;

public class QSignApp
extends GenericQSignApp
implements IQSignApplication {
    protected IMechanism detectMechanism() throws CardApplicationException {
        String encryptionAlgorithmName = this.getEncryptionAlgorithmName();
        if ("RSA".equals(encryptionAlgorithmName)) {
            Mechanism tmpMech = new Mechanism();
            tmpMech.setHashAlgorithmNames("SHA256");
            tmpMech.setId("dst");
            tmpMech.setOperation("DST");
            tmpMech.setInputEncodingAlgorithmName("Raw");
            tmpMech.setOutputEncodingAlgorithmName("PSS");
            tmpMech.setSecurityEnvironment(25);
            return tmpMech;
        }
        if ("ECDSA".equals(encryptionAlgorithmName)) {
            Mechanism tmpMech = new Mechanism();
            tmpMech.setHashAlgorithmNames("SHA256");
            tmpMech.setId("dst");
            tmpMech.setOperation("DST");
            tmpMech.setSecurityEnvironment(33);
            return tmpMech;
        }
        return null;
    }

    protected CardFileSelector getAuthenticationPath() {
        return this.getCardHolderCertificate().getPrivateKeyInfo().getDirectory();
    }

    protected CardFileSelector getDefaultApplicationPath() {
        Pkcs15CardProduct cardProduct = (Pkcs15CardProduct)this.getCardProduct();
        return cardProduct.getApplicationPath();
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setSupportedHashAlgorithmNames(DIGEST_ALGORITHMS_SHA256);
    }
}

