/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v5x;

import de.intarsys.security.smartcard.app.common.GenericAuthenticateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.Mechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import de.intarsys.tr3110.pace.PaceTools;

public class AuthenticateApp
extends GenericAuthenticateApp {
    protected void basicAuthenticate(CardFileSelector dir) throws CardApplicationException {
        PaceTools.establishPaceChannel((ICardConnection)this.getCardConnection(), (CardFileSelector)this.getAuthenticationPath(), (IPinInfo)this.getPinInfoCAN(), null, null, null);
        super.basicAuthenticate(dir);
    }

    protected IMechanism detectMechanism() throws CardApplicationException {
        String encryptionAlgorithmName = this.getEncryptionAlgorithmName();
        if ("RSA".equals(encryptionAlgorithmName)) {
            Mechanism tmpMech = new Mechanism();
            tmpMech.setHashAlgorithmNames("SHA256");
            tmpMech.setId("dst");
            tmpMech.setOperation("DST");
            tmpMech.setInputEncodingAlgorithmName("DigestInfo");
            tmpMech.setOutputEncodingAlgorithmName(null);
            tmpMech.setSecurityEnvironment(37);
            return tmpMech;
        }
        if ("ECDSA".equals(encryptionAlgorithmName)) {
            Mechanism tmpMech = new Mechanism();
            tmpMech.setHashAlgorithmNames("SHA384");
            tmpMech.setId("dst");
            tmpMech.setOperation("DST");
            tmpMech.setSecurityEnvironment(34);
            return tmpMech;
        }
        return null;
    }

    protected CardFileSelector getAuthenticationPath() {
        return this.getCardHolderCertificate().getPrivateKeyInfo().getDirectory();
    }

    protected CardFileSelector getDefaultApplicationPath() {
        Pkcs15CardProduct cardProduct = (Pkcs15CardProduct)this.getCardProduct();
        return cardProduct.getApplicationPath();
    }

    public boolean isSupportedSPE() {
        try {
            return super.isSupportedSPE() && !PaceTools.getPaceApplication((ICardConnection)this.getCardConnection()).isNative();
        }
        catch (CardApplicationException e) {
            return false;
        }
    }
}

