/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v5x;

import de.intarsys.security.smartcard.app.common.AbstractCardStateApp;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.CardInfo;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import de.intarsys.tools.string.StringTools;

public class CardStateApp
extends AbstractCardStateApp {
    public Pkcs15CardProduct getCardProduct() {
        return (Pkcs15CardProduct)super.getCardProduct();
    }

    public String getIssuer() throws CardApplicationException {
        Pkcs15Structure pkcs15 = this.getCardProduct().getPkcs15Structure();
        CardInfo tokenInfo = pkcs15.getP15TokenInfo();
        String issuer = tokenInfo.getIssuer();
        if (StringTools.isEmpty((String)issuer)) {
            return "";
        }
        return issuer;
    }

    public String getLabel() throws CardApplicationException {
        Pkcs15Structure pkcs15 = this.getCardProduct().getPkcs15Structure();
        CardInfo tokenInfo = pkcs15.getP15TokenInfo();
        return tokenInfo.getLabel();
    }

    public String getManufacturer() throws CardApplicationException {
        Pkcs15Structure pkcs15 = this.getCardProduct().getPkcs15Structure();
        CardInfo tokenInfo = pkcs15.getP15TokenInfo();
        String manufacturer = tokenInfo.getManufacturerID();
        if (StringTools.isEmpty((String)manufacturer)) {
            return "";
        }
        return manufacturer;
    }

    public String getSerialNumber() throws CardApplicationException {
        Pkcs15Structure pkcs15 = this.getCardProduct().getPkcs15Structure();
        CardInfo tokenInfo = pkcs15.getP15TokenInfo();
        String serialNumber = tokenInfo.getSerialNumber();
        return serialNumber;
    }
}

