/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v5x;

import de.intarsys.security.smartcard.app.common.AbstractInitializeCredentialApp;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.product.dtrust.v5x.DTrust5Tools;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tr3110.pace.PaceTools;
import java.security.GeneralSecurityException;

public class InitializeCredentialApp
extends AbstractInitializeCredentialApp {
    protected void basicInitializeCredentialLiteral(Secret pTransportPin, Secret pNewPin) throws CardApplicationException {
        byte[] pinBytes;
        try {
            pinBytes = CryptoTools.getBytes((Secret)pTransportPin);
        }
        catch (GeneralSecurityException e) {
            throw CardApplicationException.create((Throwable)e);
        }
        this.establishPaceChannel(pinBytes);
        super.basicInitializeCredentialLiteral(pTransportPin, pNewPin);
    }

    protected void basicInitializeCredentialSpe() throws CardApplicationException {
        this.establishPaceChannel(null);
        super.basicInitializeCredentialSpe();
    }

    protected void establishPaceChannel(byte[] pinBytes) throws CardApplicationException {
        DTrust5Tools.establishPaceChannel(this.getCardConnection(), this.getAuthenticationPath(), this.getPinInfoPace(), pinBytes, this.getPinInfoCAN(), DTrust5Tools.getPinInfoPUK(this.getCardProduct()), (Throwing.Specific.Consumer<IPinInfo, CardApplicationException>)((Throwing.Specific.Consumer)x$0 -> this.cmdResetRetryCounter((IPinInfo)x$0)));
    }

    protected IPinInfo getPinInfoPace() {
        IPinInfo tempPinInfo = this.getCardProduct().getCardInfo().lookupPinInfo("PIN.@11");
        if (this.getPinInfo() == tempPinInfo) {
            return this.getCardProduct().getCardInfo().lookupPinInfo("PIN.T.AUT");
        }
        tempPinInfo = this.getCardProduct().getCardInfo().lookupPinInfo("PIN.@07");
        if (this.getPinInfo() == tempPinInfo) {
            return this.getCardProduct().getCardInfo().lookupPinInfo("PIN.T");
        }
        return null;
    }

    public boolean isEnterCurrentPin() {
        return false;
    }

    public boolean isSupportedSPE() {
        try {
            return super.isSupportedSPE() && !PaceTools.getPaceApplication((ICardConnection)this.getCardConnection()).isNative();
        }
        catch (CardApplicationException e) {
            return false;
        }
    }
}

