/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.dtrust.v5x;

import de.intarsys.security.smartcard.app.common.GenericQSignApp;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.Mechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import de.intarsys.tr3110.pace.PaceTools;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.Collection;

public class QSignApp
extends GenericQSignApp
implements IQSignApplication {
    public static final Collection<String> DIGEST_ALGORITHMS_STANDARD = Arrays.asList("SHA-512");
    public static final Collection<String> DIGEST_ALGORITHMS_MULTI = Arrays.asList("SHA-384");

    protected void basicAuthenticate(CardFileSelector dir) throws CardApplicationException {
        PaceTools.establishPaceChannel((ICardConnection)this.getCardConnection(), (CardFileSelector)this.getAuthenticationPath(), (IPinInfo)this.getPinInfoCAN(), null, null, null);
        super.basicAuthenticate(dir);
    }

    protected IMechanism detectMechanism() throws CardApplicationException {
        String encryptionAlgorithmName = this.getEncryptionAlgorithmName();
        if ("RSA".equals(encryptionAlgorithmName)) {
            Mechanism tmpMech = new Mechanism();
            tmpMech.setHashAlgorithmNames("SHA-512");
            tmpMech.setId("dst");
            tmpMech.setSecurityEnvironment(this.getDefaultRestrictionCount());
            tmpMech.setOperation("DST");
            tmpMech.setInputEncodingAlgorithmName("Raw");
            tmpMech.setOutputEncodingAlgorithmName("PSS");
            tmpMech.setSecurityEnvironment(27);
            return tmpMech;
        }
        if ("ECDSA".equals(encryptionAlgorithmName)) {
            Mechanism tmpMech = new Mechanism();
            tmpMech.setHashAlgorithmNames("SHA-384");
            tmpMech.setId("dst");
            tmpMech.setOperation("DST");
            tmpMech.setSecurityEnvironment(34);
            return tmpMech;
        }
        return null;
    }

    protected CardFileSelector getAuthenticationPath() {
        return this.getCardHolderCertificate().getPrivateKeyInfo().getDirectory();
    }

    protected CardFileSelector getDefaultApplicationPath() {
        Pkcs15CardProduct cardProduct = (Pkcs15CardProduct)this.getCardProduct();
        return cardProduct.getApplicationPath();
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        int restriction = this.getCardProduct().getQSigRestriction(this.getCardConnection());
        if (restriction == 1) {
            this.setSupportedHashAlgorithmNames(DIGEST_ALGORITHMS_STANDARD);
        } else {
            this.setSupportedHashAlgorithmNames(DIGEST_ALGORITHMS_MULTI);
        }
    }

    public boolean isSupportedSPE() {
        try {
            return super.isSupportedSPE() && !PaceTools.getPaceApplication((ICardConnection)this.getCardConnection()).isNative();
        }
        catch (CardApplicationException e) {
            return false;
        }
    }
}

