/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.gd.eidas.c3;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.common.StarcosTools;
import de.intarsys.tools.hex.HexTools;

public class CardProduct
extends CiCardProduct {
    private static final byte[] ID_SIGN_INDIVIDUAL = HexTools.hexStringToBytes((String)"FF000110");
    private static final byte[] ID_SIGN_BATCH = HexTools.hexStringToBytes((String)"FF006410");
    private static final byte[] ID_SIGN_MASS = HexTools.hexStringToBytes((String)"FF00FF10");

    public boolean accept(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        if (!StarcosTools.matchImageId(connection, ID_SIGN_INDIVIDUAL, ID_SIGN_BATCH, ID_SIGN_MASS)) {
            return false;
        }
        return super.accept(factory, connection);
    }

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        try {
            byte[] imageId = StarcosTools.getImageID(connection);
            if (imageId[2] == 1) {
                return 1;
            }
            if (imageId[2] == 100) {
                return 100;
            }
            if (imageId[2] == 255) {
                return -1;
            }
            return super.createQSigRestriction(connection);
        }
        catch (Exception e) {
            return super.createQSigRestriction(connection);
        }
    }
}

