/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.gd.eidas.c3;

import de.intarsys.security.smartcard.app.common.AbstractPinStateApp;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateActive;
import de.intarsys.security.smartcard.common.PinStateLocked;
import de.intarsys.security.smartcard.common.PinStateNotAvailable;
import de.intarsys.security.smartcard.common.PinStateTransport;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.gematik.g2.GematikGetPinStatus;

public class PinStateApp
extends AbstractPinStateApp {
    public PinState getPinState(IPinInfo pinInfo) throws CardApplicationException {
        if (pinInfo.isResetPinInfo()) {
            return new PinStateActive(pinInfo, -1);
        }
        try {
            this.getFileSystem().selectDf(pinInfo.getDirectory(), false);
        }
        catch (Exception e) {
            return new PinStateNotAvailable(pinInfo);
        }
        GematikGetPinStatus cmdVerify = (GematikGetPinStatus)this.getCommand(GematikGetPinStatus.class);
        RequestAPDU req = cmdVerify.create(pinInfo.getReference());
        ResponseAPDU resp = this.transmit(req);
        int sw1 = resp.getSw1();
        int sw2 = resp.getSw2();
        if (sw1 == 98 && (sw2 == 193 || sw2 == 199)) {
            return new PinStateTransport(pinInfo);
        }
        if (sw1 == 98 && sw2 == 208) {
            return new PinStateNotAvailable(pinInfo);
        }
        if (sw1 == 106 && sw2 == 136) {
            return new PinStateNotAvailable(pinInfo);
        }
        if (sw1 == 99 && (sw2 & 0xF0) == 192) {
            int counter = sw2 & 0xF;
            if (counter == 0) {
                return new PinStateLocked(pinInfo);
            }
            return new PinStateActive(pinInfo, counter);
        }
        return new PinStateUnknown(pinInfo);
    }
}

