/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.gematik.ehc.g1;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationAdapter;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;

public class ReadXMLData
extends CardApplicationAdapter {
    private String fileSystemId;
    private int offsetStartSlot = -1;
    private int offsetEndSlot = -1;
    private int lengthSlot = 0;

    protected IPinInfo getAuthenticationPinInfo() {
        return null;
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return ReadXMLData.class;
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public int getLengthSlot() {
        return this.lengthSlot;
    }

    protected String getMsgPromptCodePrefix() {
        return ClassTools.getUnqualifiedName(((Object)((Object)this)).getClass());
    }

    public int getOffsetEndSlot() {
        return this.offsetEndSlot;
    }

    public int getOffsetStartSlot() {
        return this.offsetStartSlot;
    }

    public String readContent() throws CardApplicationException {
        CardFileSelector selector = this.getCardInfo().lookupFileSelector(this.getFileSystemId());
        byte[] bytes = this.getFileSystem().readBinary(selector);
        int offset = 0;
        int length = 0;
        if (this.getOffsetStartSlot() >= 0) {
            offset = ((bytes[this.getOffsetStartSlot() * 2] & 0xFF) << 8) + (bytes[this.getOffsetStartSlot() * 2 + 1] & 0xFF);
            length = ((bytes[this.getOffsetEndSlot() * 2] & 0xFF) << 8) + (bytes[this.getOffsetEndSlot() * 2 + 1] & 0xFF) - offset + 1;
        } else {
            offset = 2;
            length = ((bytes[this.getLengthSlot() * 2] & 0xFF) << 8) + (bytes[this.getLengthSlot() * 2 + 1] & 0xFF);
        }
        if (offset == 4095) {
            return "";
        }
        byte[] zippedData = ByteArrayTools.copy((byte[])bytes, (int)offset, (int)length);
        ByteArrayInputStream is = new ByteArrayInputStream(zippedData);
        try {
            GZIPInputStream zis = new GZIPInputStream(is);
            byte[] data = StreamTools.getBytes((InputStream)zis);
            return new String(data, StandardCharsets.ISO_8859_1);
        }
        catch (IOException e) {
            throw CardApplicationException.create((String)"can not read data", (Throwable)e);
        }
    }

    public void setFileSystemId(String fileId) {
        this.fileSystemId = fileId;
    }

    public void setLengthSlot(int lengthSlot) {
        this.lengthSlot = lengthSlot;
    }

    public void setOffsetEndSlot(int lengthSlot) {
        this.offsetEndSlot = lengthSlot;
    }

    public void setOffsetStartSlot(int offsetSlot) {
        this.offsetStartSlot = offsetSlot;
    }
}

