/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.gematik.hpc.g1;

import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import de.intarsys.tools.tlv.common.TlvTools;
import java.util.Iterator;

public class CardProduct
extends CiCardProduct {
    protected int readRestrictionFromEfSsec(ICardConnection connection) {
        try {
            IFileSystemApplication fileSystem = (IFileSystemApplication)this.createCardApplication(connection, IFileSystemApplication.class);
            fileSystem.selectDf(this.getCardInfo().lookupFileSelector("AID_QES"), false);
            byte[] ssec = fileSystem.readBinary(this.getCardInfo().lookupFileSelector("EF.SSEC"));
            Iso7816BerElement tlvSsec = Iso7816BerElement.parseElement((byte[])ssec, (int)0, (int)ssec.length);
            if (tlvSsec != null) {
                TlvTemplate tlvSsecTemplate = tlvSsec.getTemplate();
                Iterator tlvSsecIt = tlvSsecTemplate.iterator();
                while (tlvSsecIt.hasNext()) {
                    TlvElement tlvSsecChild = (TlvElement)tlvSsecIt.next();
                    if (tlvSsecChild.getIdentifier() != 128 || TlvTools.asInt((TlvElement)tlvSsecChild) != 2 || !tlvSsecIt.hasNext() || (tlvSsecChild = (TlvElement)tlvSsecIt.next()).getIdentifier() != 164) continue;
                    for (TlvElement tlvAtChild : tlvSsecChild.getTemplate()) {
                        if (tlvAtChild.getIdentifier() != 192) continue;
                        int restriction = TlvTools.asUnsignedInt((TlvElement)tlvAtChild);
                        if (restriction == 255) {
                            return Integer.MAX_VALUE;
                        }
                        return restriction;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }
}

