/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.gematik.hpc.g1;

import de.intarsys.security.smartcard.app.common.AbstractPinStateApp;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateActive;
import de.intarsys.security.smartcard.common.PinStateLocked;
import de.intarsys.security.smartcard.common.PinStateNotAvailable;
import de.intarsys.security.smartcard.common.PinStateTransport;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardStatusCodeException;
import de.intarsys.security.smartcard.os.gematik.g1.EGKTools;

public class PinStateApp
extends AbstractPinStateApp {
    public PinState getPinState(IPinInfo pinInfo) throws CardApplicationException {
        if (pinInfo.isResetPinInfo()) {
            return new PinStateUnknown(pinInfo, false);
        }
        try {
            ResponseAPDU response = EGKTools.getPinState(this.getFileSystem(), this.getCardTransmitter(), pinInfo);
            int sw1 = response.getSw1();
            int sw2 = response.getSw2();
            if (sw1 == 144 && sw2 == 0) {
                return new PinStateUnknown(pinInfo);
            }
            if (sw1 == 98) {
                return new PinStateTransport(pinInfo);
            }
            if (sw1 == 99 && (sw2 & 0xF0) == 192) {
                int retries = sw2 & 0xF;
                if (retries == 0) {
                    return new PinStateLocked(pinInfo);
                }
                return new PinStateActive(pinInfo, retries);
            }
            throw new CardStatusCodeException(sw1, sw2);
        }
        catch (Exception e) {
            return new PinStateNotAvailable(pinInfo);
        }
    }
}

