/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.gematik.hpc.g2;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardProduct
extends CiCardProduct {
    private static final Logger Log = LoggerFactory.getLogger(CardProduct.class);

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        try {
            IFileSystemApplication fileSystem = (IFileSystemApplication)this.createCardApplication(connection, IFileSystemApplication.class);
            CardFileSelector selector = this.getCardInfo().lookupFileSelector("EF.SSEC");
            if (selector == null) {
                Log.debug("{} no EF.SSEC found", (Object)this);
                return super.createQSigRestriction(connection);
            }
            byte[] bytes = fileSystem.readBinary(selector);
            TlvTemplate tplEF = Iso7816BerElement.parseTemplate((byte[])bytes, (int)0, (int)bytes.length);
            TlvElement elementEF = tplEF.getElementAt(0);
            Iterator it = elementEF.getTemplate().iterator();
            while (it.hasNext()) {
                TlvElement next = (TlvElement)it.next();
                if (next.getIdentifier() != 128 || next.getLength() != 1 || next.getValue()[0] != 1 || (next = (TlvElement)it.next()).getIdentifier() != 164) continue;
                TlvTemplate tplAT = next.getTemplate();
                TlvElement ssec = tplAT.getElementTagged(192);
                return ssec.getValue()[0] & 0xFF;
            }
            Log.debug("{} read EF.SSEC SE1 AT template ssec counter not found", (Object)this);
            Log.debug("{} EF.SSEC content\n{}", (Object)this, (Object)HexTools.bytesToHexString((byte[])bytes));
            return super.createQSigRestriction(connection);
        }
        catch (Exception e) {
            Log.debug("{} read EF.SSEC failed", (Object)this, (Object)e);
            return super.createQSigRestriction(connection);
        }
    }
}

