/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.gematik.hpc.g2;

import de.intarsys.security.smartcard.app.common.AbstractCardStateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.common.ICCSN;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.hex.HexTools;
import java.io.IOException;

public class CardStateApp
extends AbstractCardStateApp {
    public ICCSN getICCSN() throws CardApplicationException {
        try {
            Iso7816BerElement element;
            byte[] gdo = this.getFileSystem().readBinaryCached(this.getCardInfo().lookupFileSelector("EF.GDO"));
            if (gdo.length > 2 && (element = Iso7816BerElement.parseElement((byte[])gdo, (int)0, (int)gdo.length)) != null) {
                byte[] serialNumber = element.getValue();
                return new ICCSN(serialNumber);
            }
        }
        catch (CardFileNotFoundException gdo) {
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
        return null;
    }

    public String getSerialNumber() throws CardApplicationException {
        ICCSN iccsn = this.getICCSN();
        if (iccsn != null) {
            return HexTools.bytesToHexString((byte[])iccsn.getBytes());
        }
        return "00";
    }
}

