/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.npa;

import de.intarsys.security.smartcard.app.common.IExtractCertificateApplication;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.tlv.Iso7816SimpleInputStream;
import de.intarsys.security.smartcard.model.CardApplicationInfo;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.ICardHolderCertificateInfo;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationBinding;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.product.npa.NPATools;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tr3110.pace.IPaceApplication;
import de.intarsys.tr3110.pace.PaceTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class CardProduct
extends CiCardProduct {
    public static final String PIN_CAN = "PIN.CAN";
    public static final String PIN_PIN = "PIN.PIN";
    public static final String PIN_QSIG = "PIN.QSIG";

    public boolean accept(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        boolean accept = super.accept(factory, connection);
        if (accept) {
            return this.isEIDApplicationSupported(factory, connection);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEIDApplicationSupported(ICardProductFactory factory, ICardConnection connection) {
        CardFileSelector efDIR = this.getCardInfo().lookupFileSelector("EF.DIR");
        byte[] eIDAppId = HexTools.hexStringToBytes((String)"E80704007F00070302");
        try {
            IFileSystemApplication fileSystem = (IFileSystemApplication)this.createCardApplication(connection, IFileSystemApplication.class);
            byte[] bytesDIR = fileSystem.readBinary(efDIR);
            try (Iso7816SimpleInputStream in = new Iso7816SimpleInputStream(bytesDIR, 0, bytesDIR.length);){
                TlvElement element;
                byte[] appId;
                do {
                    if ((element = in.readElement()) == null) return false;
                } while (!Arrays.equals(eIDAppId, appId = element.getTemplate().getElementAt(0).getValue()));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void updateCardApplicationInfo(ICardConnection connection, CardApplicationInfo appInfo) throws CardApplicationException {
        super.updateCardApplicationInfo(connection, appInfo);
        if (IExtractCertificateApplication.class.isAssignableFrom(appInfo.getCardApplicationType()) || ISignApplication.class.isAssignableFrom(appInfo.getCardApplicationType())) {
            IPinInfo canPinInfo = this.getCardInfo().lookupPinInfo(PIN_CAN);
            PaceTools.establishPaceChannel((ICardConnection)connection, null, (IPinInfo)canPinInfo, null, (String)"0.4.0.127.0.7.3.1.2.3", (byte[])IPaceApplication.DD_SIGNATURE_TERMINAL);
            Collection infos = NPATools.getPkcs15((ICardProduct)this, connection).getCardHolderCertificateInfosQes();
            if (infos.size() == 0) {
                infos = NPATools.getPkcs15((ICardProduct)this, connection).getCardHolderCertificateInfosSignature();
            }
            ArrayList<CardApplicationBinding> result = new ArrayList<CardApplicationBinding>();
            for (ICardHolderCertificateInfo certInfo : infos) {
                CardApplicationBinding binding = new CardApplicationBinding();
                binding.setCardHolderCertificateInfo(certInfo);
                result.add(binding);
            }
            CardApplicationInfo tempInfo = (CardApplicationInfo)this.getCardInfo().lookupCardApplicationInfo(IExtractCertificateApplication.class);
            this.setBindings(tempInfo, result);
            tempInfo = (CardApplicationInfo)this.getCardInfo().lookupCardApplicationInfo(ISignApplication.class);
            this.setBindings(tempInfo, result);
            tempInfo = (CardApplicationInfo)this.getCardInfo().lookupCardApplicationInfo(IQSignApplication.class);
            this.setBindings(tempInfo, result);
        }
    }
}

