/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.npa;

import de.intarsys.security.smartcard.app.common.AbstractCardStateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.security.smartcard.product.npa.NPATools;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;

public class CardStateApp
extends AbstractCardStateApp {
    private static final CardFilePath EF_GDO = new CardFilePath("3F00:2F02");

    public String getGDOSerialNumber() throws CardApplicationException {
        try {
            Iso7816BerElement element;
            byte[] gdo = this.getFileSystem().readBinaryCached((CardFileSelector)EF_GDO);
            if (gdo.length > 2 && (element = Iso7816BerElement.parseElement((byte[])gdo, (int)0, (int)gdo.length)) != null) {
                byte[] serialNumber = element.getValue();
                return HexTools.bytesToHexString((byte[])serialNumber);
            }
        }
        catch (CardApplicationException gdo) {
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
        return "00";
    }

    public String getIssuer() throws CardApplicationException {
        String issuer = null;
        Pkcs15Structure cardInfo = NPATools.lookupPkcs15(this.getCardConnection());
        if (cardInfo != null) {
            issuer = cardInfo.getP15TokenInfo().getIssuer();
        }
        if (StringTools.isEmpty(issuer)) {
            return "";
        }
        return issuer;
    }

    public String getLabel() throws CardApplicationException {
        String label = null;
        Pkcs15Structure cardInfo = NPATools.lookupPkcs15(this.getCardConnection());
        if (cardInfo != null) {
            label = cardInfo.getP15TokenInfo().getLabel();
        }
        if (StringTools.isEmpty(label)) {
            return super.getLabel();
        }
        return label;
    }

    public String getManufacturer() {
        String manufacturer = null;
        Pkcs15Structure cardInfo = NPATools.lookupPkcs15(this.getCardConnection());
        if (cardInfo != null) {
            manufacturer = cardInfo.getP15TokenInfo().getManufacturerID();
        }
        if (StringTools.isEmpty(manufacturer)) {
            return "";
        }
        return manufacturer;
    }

    public String getSerialNumber() throws CardApplicationException {
        String serialNumber = null;
        Pkcs15Structure cardInfo = NPATools.lookupPkcs15(this.getCardConnection());
        if (cardInfo != null) {
            serialNumber = cardInfo.getP15TokenInfo().getSerialNumber();
        }
        if (StringTools.isEmpty(serialNumber)) {
            serialNumber = this.getGDOSerialNumber();
        }
        return serialNumber;
    }
}

