/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.npa;

import de.intarsys.security.smartcard.app.common.AbstractChangeCredentialApp;
import de.intarsys.security.smartcard.app.common.IPinStateApplication;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.SpeRequiredException;
import de.intarsys.security.smartcard.model.cmd.ICmdChangeReferenceData;
import de.intarsys.security.smartcard.model.cmd.ICmdResetRetryCounter;
import de.intarsys.tr3110.pace.IPaceApplication;
import de.intarsys.tr3110.pace.PaceTools;

public class ChangeCredentialApp
extends AbstractChangeCredentialApp {
    protected void basicBeginTransaction() throws CardApplicationException {
        IPinInfo pacePinInfo;
        byte[] discretionaryData;
        String chatId;
        if ("PIN.QSIG".equals(this.getPinInfo().getId())) {
            chatId = "0.4.0.127.0.7.3.1.2.3";
            discretionaryData = IPaceApplication.DD_SIGNATURE_TERMINAL;
            pacePinInfo = this.getCardInfo().lookupPinInfo("PIN.CAN");
        } else if ("PIN.PIN".equals(this.getPinInfo().getId())) {
            chatId = null;
            discretionaryData = null;
            pacePinInfo = this.getCardInfo().lookupPinInfo("PIN.PIN");
            if (this.isPinSuspended()) {
                IPinInfo canPinInfo = this.getCardInfo().lookupPinInfo("PIN.CAN");
                PaceTools.establishPaceChannel((ICardConnection)this.getCardConnection(), (CardFileSelector)this.getPinInfo().getDirectory(), (IPinInfo)canPinInfo, null, null, null);
            }
        } else {
            throw new CardApplicationException("only QSig or eID PINs supported");
        }
        PaceTools.establishPaceChannel((ICardConnection)this.getCardConnection(), (CardFileSelector)this.getPinInfo().getDirectory(), (IPinInfo)pacePinInfo, null, (String)chatId, (byte[])discretionaryData);
        super.basicBeginTransaction();
    }

    protected void basicChangeCredentialSpeEid() throws CardApplicationException {
        this.getFileSystem().selectDf(this.getPinInfo().getDirectory(), false);
        IPinCodec pinCodec = this.getPinInfo().getPinCodec();
        ICmdResetRetryCounter cmdReset = (ICmdResetRetryCounter)this.getCommand(ICmdResetRetryCounter.class);
        RequestAPDU template = cmdReset.createWithNewReferenceData(this.getPinInfo().getReference(), pinCodec.getTemplate());
        this.setEnterCurrentPin(false);
        boolean indirect = this.getPinEntryApplication().supportsPinModifyIndirect(this.getPinInfo().getPinCodec());
        ResponseAPDU response = this.getPinEntryApplication().sendModifyRequest(template, pinCodec, this.isEnterCurrentPin(), this.getMsgPrompts(indirect));
        this.getCardProduct().checkResponse(template, response);
    }

    protected void basicChangeCredentialSpeQSig() throws CardApplicationException {
        this.getFileSystem().selectDf(this.getPinInfo().getDirectory(), false);
        IPinCodec pinCodec = this.getPinInfo().getPinCodec();
        ICmdChangeReferenceData cmdModify = (ICmdChangeReferenceData)this.getCommand(ICmdChangeReferenceData.class);
        RequestAPDU template = cmdModify.create(this.getPinInfo().getReference(), pinCodec.getTemplate(), pinCodec.getTemplate());
        this.setEnterCurrentPin(true);
        boolean indirect = this.getPinEntryApplication().supportsPinModifyIndirect(this.getPinInfo().getPinCodec());
        ResponseAPDU response = this.getPinEntryApplication().sendModifyRequest(template, pinCodec, this.isEnterCurrentPin(), this.getMsgPrompts(indirect));
        this.getCardProduct().checkResponse(template, response);
    }

    public void changeCredential() throws CardApplicationException {
        if (this.isSupportedSPE()) {
            this.basicBeginTransaction();
            if ("PIN.QSIG".equals(this.getPinInfo().getId())) {
                this.basicChangeCredentialSpeQSig();
            } else {
                this.basicChangeCredentialSpeEid();
            }
        } else {
            throw new SpeRequiredException();
        }
    }

    private boolean isPinSuspended() throws CardApplicationException {
        IPinStateApplication pinStateApp = (IPinStateApplication)this.getCardProduct().createCardApplication(this.getCardConnection(), IPinStateApplication.class);
        PinState pinState = pinStateApp.getPinState(this.getPinInfo());
        return pinState.getRetries() == 1;
    }
}

