/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.npa;

import de.intarsys.security.smartcard.app.common.AbstractInitializeCredentialApp;
import de.intarsys.security.smartcard.app.common.IPinStateApplication;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.SpeRequiredException;
import de.intarsys.security.smartcard.model.cmd.ICmdResetRetryCounter;
import de.intarsys.security.smartcard.model.cmd.ICmdTerminate;
import de.intarsys.security.smartcard.os.npa.CmdTerminate;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tr3110.pace.IPaceApplication;
import de.intarsys.tr3110.pace.PaceTools;

public class InitializeCredentialApp
extends AbstractInitializeCredentialApp {
    protected void basicBeginTransaction() throws CardApplicationException {
        byte[] discretionaryData;
        String chatId;
        if ("PIN.QSIG".equals(this.getPinInfo().getId())) {
            chatId = "0.4.0.127.0.7.3.1.2.3";
            discretionaryData = IPaceApplication.DD_SIGNATURE_TERMINAL;
        } else if ("PIN.PIN".equals(this.getPinInfo().getId())) {
            chatId = null;
            discretionaryData = null;
        } else {
            throw new CardApplicationException("only QSig or eID PINs supported");
        }
        IPinInfo pinPinInfo = this.getCardInfo().lookupPinInfo("PIN.PIN");
        if (this.isPinSuspended(pinPinInfo)) {
            IPinInfo canPinInfo = this.getCardInfo().lookupPinInfo("PIN.CAN");
            PaceTools.establishPaceChannel((ICardConnection)this.getCardConnection(), (CardFileSelector)this.getPinInfo().getDirectory(), (IPinInfo)pinPinInfo, null, (String)chatId, (byte[])discretionaryData);
        }
        PaceTools.establishPaceChannel((ICardConnection)this.getCardConnection(), (CardFileSelector)this.getPinInfo().getDirectory(), (IPinInfo)pinPinInfo, null, (String)chatId, (byte[])discretionaryData);
        super.basicBeginTransaction();
    }

    protected void basicInitializeCredentialQSig() throws CardApplicationException {
        this.getFileSystem().selectDf(this.getPinInfo().getDirectory(), false);
        this.terminatePinQes();
        this.terminatePrKeyQes();
        super.basicInitializeCredentialSpe();
    }

    protected void basicInitializeCredentialSpePin() throws CardApplicationException {
        this.getFileSystem().selectDf(this.getPinInfo().getDirectory(), false);
        IPinCodec pinCodec = this.getPinInfo().getPinCodec();
        ICmdResetRetryCounter cmdReset = (ICmdResetRetryCounter)this.getCommand(ICmdResetRetryCounter.class);
        RequestAPDU template = cmdReset.createWithNewReferenceData(this.getPinInfo().getReference(), pinCodec.getTemplate());
        ResponseAPDU response = this.getPinEntryApplication().sendModifyRequest(template, pinCodec, this.isEnterCurrentPin(), this.getMsgPrompts(false));
        this.getCardProduct().checkResponse(template, response);
    }

    protected IMessage[] getMsgPrompts(boolean indirect) throws CardApplicationException {
        return new IMessage[]{this.getMsgPromptNew(true), this.getMsgPromptRepeat(true)};
    }

    public void initializeCredential() throws CardApplicationException {
        if (this.isSupportedSPE()) {
            this.basicBeginTransaction();
            if ("PIN.QSIG".equals(this.getPinInfo().getId())) {
                this.basicInitializeCredentialQSig();
            } else {
                this.basicInitializeCredentialSpePin();
            }
        } else {
            throw new SpeRequiredException();
        }
    }

    public boolean isEnterCurrentPin() {
        return false;
    }

    private boolean isPinSuspended(IPinInfo pinInfo) throws CardApplicationException {
        IPinStateApplication pinStateApp = (IPinStateApplication)this.getCardProduct().createCardApplication(this.getCardConnection(), IPinStateApplication.class);
        PinState pinState = pinStateApp.getPinState(pinInfo);
        return pinState.getRetries() == 1;
    }

    private void terminatePinQes() throws CardApplicationException {
        CmdTerminate cmd = (CmdTerminate)this.getCommand(ICmdTerminate.class);
        RequestAPDU req = cmd.createTerminatePin(this.getPinInfo().getReference());
        this.sendRequest(cmd, req);
    }

    private void terminatePrKeyQes() throws CardApplicationException {
        CmdTerminate cmd = (CmdTerminate)this.getCommand(ICmdTerminate.class);
        RequestAPDU req = cmd.createTerminateKey(132);
        this.sendRequest(cmd, req);
    }
}

