/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.npa;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.common.CommonPinCodec;
import de.intarsys.security.smartcard.model.ICardApplicationFactory;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.Pkcs15CardHolderCertificateInfo;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.security.smartcard.product.npa.PACKAGE;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NPATools {
    private static final Logger Log = LoggerFactory.getLogger(NPATools.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Attribute ATTR_PKCS15 = new Attribute("pkcs15");

    public static Pkcs15Structure getPkcs15(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        if (NPATools.lookupPkcs15(connection) == null) {
            NPATools.initPkcs15(product, connection);
        }
        return NPATools.lookupPkcs15(connection);
    }

    public static void initPkcs15(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        Pkcs15Structure pkcs15 = new Pkcs15Structure();
        pkcs15.setPKCS15AID(product.getCardInfo().lookupFileSelector("AID_CIAESIGN"));
        pkcs15.setApplicationAID(product.getCardInfo().lookupFileSelector("AID_ESIGN"));
        pkcs15.initialize((ICardApplicationFactory)product, connection);
        Collection sigCertInfos = pkcs15.getCardHolderCertificateInfosQes();
        if (sigCertInfos.size() == 0) {
            sigCertInfos = pkcs15.getCardHolderCertificateInfosSignature();
        }
        if (sigCertInfos.size() >= 1) {
            Pkcs15CardHolderCertificateInfo ci = (Pkcs15CardHolderCertificateInfo)sigCertInfos.iterator().next();
            IPinInfo pi = product.getCardInfo().lookupPinInfo("PIN.QSIG");
            ((CommonPinCodec)ci.getPinInfo().getPinCodec()).setMinCharacters(pi.getPinCodec().getMinCharacters());
            ((CommonPinCodec)ci.getPinInfo().getPinCodec()).setMaxCharacters(pi.getPinCodec().getMaxCharacters());
        }
        connection.getCard().setAttribute((Object)ATTR_PKCS15, (Object)pkcs15);
    }

    protected static Pkcs15Structure lookupPkcs15(ICardConnection connection) {
        return (Pkcs15Structure)connection.getCard().getAttribute((Object)ATTR_PKCS15);
    }
}

