/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.npa;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.smartcard.app.common.AbstractPinStateApp;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateActive;
import de.intarsys.security.smartcard.common.PinStateInactive;
import de.intarsys.security.smartcard.common.PinStateLocked;
import de.intarsys.security.smartcard.common.PinStateNPAQSig;
import de.intarsys.security.smartcard.common.PinStateTransport;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tr3110.asn1.CryptographicMechanismReference;
import de.intarsys.tr3110.asn1.PACEInfo;
import de.intarsys.tr3110.asn1.PublicKeyReference;
import de.intarsys.tr3110.asn1.SecurityInfos;
import de.intarsys.tr3110.common.CommonTools;
import java.io.IOException;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;

public class PinStateApp
extends AbstractPinStateApp {
    public PinState getPinState(IPinInfo pinInfo) throws CardApplicationException {
        if ("PIN.QSIG".equals(pinInfo.getId())) {
            return new PinStateNPAQSig(pinInfo, -1);
        }
        if ("PIN.PIN".equals(pinInfo.getId())) {
            try {
                SecurityInfos securityInfos = CommonTools.getSecurityInfos((ICardProduct)this.getCardProduct(), (ICardConnection)this.getCardConnection());
                List paceInfos = securityInfos.getPACEInfos();
                if (paceInfos.isEmpty()) {
                    throw new CardApplicationException("PACE not supported");
                }
                CryptographicMechanismReference asnCRM = (CryptographicMechanismReference)CryptographicMechanismReference.FACTORY.createNew();
                asnCRM.setProtocol(((PACEInfo)paceInfos.get(0)).getProtocol());
                PublicKeyReference asnPkr = (PublicKeyReference)PublicKeyReference.FACTORY.createNew();
                asnPkr.setReference(pinInfo.getReference());
                byte[] data = ASN1Tools.toByteArray((ASN1Encodable[])new ASN1Encodable[]{asnCRM, asnPkr});
                RequestAPDU req = new RequestAPDU(0, 34, 193, 164, data, -1, false);
                req.setLabel("NPA get pin state");
                ResponseAPDU resp = this.transmit(req);
                int sw1 = resp.getSw1();
                int sw2 = resp.getSw2();
                if (sw1 == 99 && (sw2 & 0xF0) == 192) {
                    int counter = sw2 & 0xF;
                    if (counter == 0) {
                        return new PinStateLocked(pinInfo);
                    }
                    return new PinStateActive(pinInfo, counter);
                }
                if (sw1 == 98 && sw2 == 131) {
                    return new PinStateInactive(pinInfo);
                }
                if (sw1 == 144 && sw2 == 0) {
                    return new PinStateActive(pinInfo, -1);
                }
                return new PinStateUnknown(pinInfo);
            }
            catch (IOException e) {
                throw CardApplicationException.create((Throwable)e);
            }
        }
        try {
            this.getFileSystem().selectDf(pinInfo.getDirectory(), false);
            ResponseAPDU resp = this.cmdVerify(pinInfo);
            int sw1 = resp.getSw1();
            int sw2 = resp.getSw2();
            if (sw1 == 99 && (sw2 & 0xF0) == 192) {
                int counter = sw2 & 0xF;
                if (counter == 0) {
                    return new PinStateLocked(pinInfo);
                }
                return new PinStateActive(pinInfo, counter);
            }
            if (sw1 == 105 && sw2 == 133) {
                return new PinStateTransport(pinInfo);
            }
        }
        catch (CardApplicationException cardApplicationException) {
            // empty catch block
        }
        return new PinStateUnknown(pinInfo);
    }
}

