/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.npa;

import de.intarsys.security.algorithm.ec.EcdsaTools;
import de.intarsys.security.smartcard.app.common.AbstractSignApp;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.digest.IDigest;
import jakarta.annotation.PostConstruct;
import java.security.PublicKey;

public class QSignApp
extends AbstractSignApp
implements IQSignApplication {
    protected void basicResetSecurityStateCard() {
    }

    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        byte[] keyRef = this.getCardHolderCertificate().getPrivateKeyInfo().getReference();
        this.cmdMseSetComponentKey(182, keyRef);
        IDigest digest = this.parseDigest(data);
        byte[] signature = this.cmdPsoComputeDigitalSignature(digest.getBytes()).getData();
        return EcdsaTools.encodeDerSigValue((byte[])signature, (PublicKey)this.getCardHolderCertificate().getPublicKey());
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IQSignApplication.class;
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setRestrictionCount(1);
        this.setSupportedHashAlgorithmNames(DIGEST_ALGORITHMS_SHA1_SHA256_RIPEMD160);
    }
}

