/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.pkcs15;

import de.intarsys.security.encoding.PKCS1Type1Encoding;
import de.intarsys.security.smartcard.app.common.AbstractAuthenticateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import java.io.IOException;

public class AuthenticateApp
extends AbstractAuthenticateApp {
    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        byte[] padded;
        PKCS1Type1Encoding encoding = new PKCS1Type1Encoding();
        encoding.setIntendedLengthBits(this.getCardHolderCertificate().getKeyBitSize());
        try {
            padded = encoding.encode(data);
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
        this.cmdMseSetComponentKey(184, this.getCardHolderCertificate().getPrivateKeyInfo().getReference());
        return this.cmdPsoDecipher(padded, 0, 0).getData();
    }

    protected CardFileSelector getAuthenticationPath() {
        return this.getCardHolderCertificate().getPrivateKeyInfo().getDirectory();
    }

    protected CardFileSelector getDefaultApplicationPath() {
        Pkcs15CardProduct cardProduct = (Pkcs15CardProduct)this.getCardProduct();
        return cardProduct.getApplicationPath();
    }
}

