/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.pkcs15;

import de.intarsys.security.smartcard.app.common.AbstractCardStateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.CardInfo;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;

public class CardStateApp
extends AbstractCardStateApp {
    private static final CardFilePath EF_GDO = new CardFilePath(":3F00:2F02");

    public Pkcs15CardProduct getCardProduct() {
        return (Pkcs15CardProduct)super.getCardProduct();
    }

    public String getGDOSerialNumber() throws CardApplicationException {
        try {
            Iso7816BerElement element;
            byte[] gdo = this.getFileSystem().readBinaryCached((CardFileSelector)EF_GDO);
            if (gdo.length > 2 && (element = Iso7816BerElement.parseElement((byte[])gdo, (int)0, (int)gdo.length)) != null) {
                byte[] serialNumber = element.getValue();
                return HexTools.bytesToHexString((byte[])serialNumber);
            }
        }
        catch (CardFileNotFoundException gdo) {
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
        return "00";
    }

    public String getIssuer() throws CardApplicationException {
        Pkcs15Structure pkcs15 = this.getCardProduct().getPkcs15Structure();
        CardInfo tokenInfo = pkcs15.getP15TokenInfo();
        String issuer = tokenInfo.getIssuer();
        if (StringTools.isEmpty((String)issuer)) {
            return "";
        }
        return issuer;
    }

    public String getLabel() throws CardApplicationException {
        Pkcs15Structure pkcs15 = this.getCardProduct().getPkcs15Structure();
        CardInfo tokenInfo = pkcs15.getP15TokenInfo();
        return tokenInfo.getLabel();
    }

    public String getManufacturer() throws CardApplicationException {
        Pkcs15Structure pkcs15 = this.getCardProduct().getPkcs15Structure();
        CardInfo tokenInfo = pkcs15.getP15TokenInfo();
        String manufacturer = tokenInfo.getManufacturerID();
        if (StringTools.isEmpty((String)manufacturer)) {
            return "";
        }
        return manufacturer;
    }

    public String getSerialNumber() throws CardApplicationException {
        Pkcs15Structure pkcs15 = this.getCardProduct().getPkcs15Structure();
        CardInfo tokenInfo = pkcs15.getP15TokenInfo();
        String serialNumber = tokenInfo.getSerialNumber();
        if (StringTools.isEmpty((String)serialNumber)) {
            serialNumber = this.getGDOSerialNumber();
        }
        return serialNumber;
    }
}

