/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.pkcs15;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardHolderCertificate;
import de.intarsys.security.smartcard.model.CiCardInfo;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.ICardApplicationFactory;
import de.intarsys.security.smartcard.model.ICardHolderCertificateInfo;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.CardInfo;
import de.intarsys.security.smartcard.pkcs15.CiCardInfoPkcs15Builder;
import de.intarsys.security.smartcard.pkcs15.KeyUsageFlags;
import de.intarsys.security.smartcard.pkcs15.Pkcs15CardHolderCertificateInfo;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.tools.component.ConfigurationException;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;

public class Pkcs15CardProduct
extends CiCardProduct {
    public boolean accept(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        if (!super.accept(factory, connection)) {
            return false;
        }
        return this.getCardInfo().getPkcs15Structure() != null;
    }

    public void accepted(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        super.accepted(factory, connection);
        this.getPkcs15Structure().setMessageBundle(this.getMessageBundle());
    }

    public boolean acceptProperty(ICardProductFactory factory, ICardConnection connection, String key, String value) throws CardApplicationException {
        if ("pkcs15.tokenInfo.label".equals(key)) {
            try {
                Pkcs15Structure pkcs15 = this.getCardInfo().getPkcs15Structure();
                CardInfo tokenInfo = pkcs15.getP15TokenInfo();
                String label = tokenInfo.getLabel();
                return Pattern.matches(value, label);
            }
            catch (Exception e) {
                return false;
            }
        }
        if ("certificate.issuer.name".equals(key)) {
            try {
                Pkcs15Structure pkcs15 = this.getCardInfo().getPkcs15Structure();
                Collection certificateInfos = pkcs15.getCardHolderCertificateInfos();
                for (ICardHolderCertificateInfo info : certificateInfos) {
                    CardHolderCertificate cert = CardHolderCertificate.create((ICardProduct)this, (ICardConnection)connection, (ICardHolderCertificateInfo)info);
                    if (cert == null) continue;
                    X500Principal principal = cert.getIssuerX500Principal();
                    String name = principal.toString();
                    return Pattern.matches(value, name);
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return super.acceptProperty(factory, connection, key, value);
    }

    public CardFileSelector getApplicationPath() {
        return this.getPkcs15Structure().getApplicationPath();
    }

    public Pkcs15Structure getPkcs15Structure() {
        return this.getCardInfo().getPkcs15Structure();
    }

    protected void initializeCardInfo(ICardConnection connection, CiCardInfo cardInfo) throws ConfigurationException {
        super.initializeCardInfo(connection, cardInfo);
        new CiCardInfoPkcs15Builder((ICardApplicationFactory)this, connection).process(cardInfo);
    }

    public boolean isDSIFileUsed() {
        return false;
    }

    public boolean isUseCT(Pkcs15CardHolderCertificateInfo certificateInfo) {
        KeyUsageFlags flags = this.getPkcs15Structure().getPrivateKeyUsageFlags(certificateInfo.getCertObjId());
        return flags.isDecrypt() && flags.isSign() && flags.isUnwrap();
    }
}

