/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.pkcs15;

import de.intarsys.security.smartcard.app.common.AbstractSignApp;
import de.intarsys.security.smartcard.app.common.IAdvSignApplication;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import de.intarsys.tools.digest.IDigest;
import jakarta.annotation.PostConstruct;
import java.io.IOException;

public class QSignApp
extends AbstractSignApp
implements IQSignApplication,
IAdvSignApplication {
    private boolean dsiFileUsed = false;

    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        byte[] digestBytes;
        IDigest digest = this.parseDigest(data);
        this.cmdMseSetComponentKey(182, this.getCardHolderCertificate().getPrivateKeyInfo().getReference());
        if (this.isDsiFileUsed()) {
            digestBytes = digest.getBytes();
        } else {
            try {
                digestBytes = digest.getEncoded();
            }
            catch (IOException e) {
                throw CardApplicationException.create((Throwable)e);
            }
        }
        return this.cmdPsoComputeDigitalSignature(digestBytes).getData();
    }

    protected CardFileSelector getAuthenticationPath() {
        return this.getCardHolderCertificate().getPrivateKeyInfo().getDirectory();
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IQSignApplication.class;
    }

    protected CardFileSelector getDefaultApplicationPath() {
        Pkcs15CardProduct cardProduct = (Pkcs15CardProduct)this.getCardProduct();
        return cardProduct.getApplicationPath();
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        this.setRestrictionCount(this.getCardProduct().getQSigRestriction(this.getCardConnection()));
        super.initialize();
        Pkcs15CardProduct cardProduct = (Pkcs15CardProduct)this.getCardProduct();
        if (cardProduct.isDSIFileUsed()) {
            this.setDSIFileUsed(true);
            this.setSupportedHashAlgorithmNames(DIGEST_ALGORITHMS_SHA1);
        }
    }

    public boolean isDsiFileUsed() {
        return this.dsiFileUsed;
    }

    public void setDSIFileUsed(boolean pDsiFileUsed) {
        this.dsiFileUsed = pDsiFileUsed;
    }
}

