/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.quovadis.v1;

import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.PinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.AlgorithmInfo;
import de.intarsys.security.smartcard.pkcs15.Pkcs15CardHolderCertificateInfo;
import de.intarsys.security.smartcard.pkcs15.PrivateKeyObject;
import de.intarsys.security.smartcard.pkcs15.PrivateRSAKeyAttributes;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import de.intarsys.security.smartcard.product.quovadis.v1.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;

public class CardProduct
extends Pkcs15CardProduct {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public void accepted(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        super.accepted(factory, connection);
        for (IPinInfo info : this.getCardInfo().getPinInfos()) {
            ((PinInfo)info).setTransportLength(5);
        }
        for (IPinInfo info : this.getCardInfo().getCardHolderCertificateInfos()) {
            IPinInfo puk = info.getPinInfo().getResettingPinInfo();
            if (puk == null) continue;
            if (puk.getReference() == 138) {
                ((PinInfo)puk).setFixed(true);
                ((PinInfo)info.getPinInfo()).setResettingPinInfo(null);
                ((PinInfo)info.getPinInfo()).setTransportLabel(Msg.getString("PIN.Transport.label", new Object[0]));
                continue;
            }
            if (puk.getReference() != 130) continue;
            ((Pkcs15CardHolderCertificateInfo)info).setCertificateUsage(CertificateUsage.SIGNATURE_WITHOUT_NONREPUDIATION);
        }
    }

    @Override
    public boolean isUseCT(Pkcs15CardHolderCertificateInfo certificateInfo) {
        AlgorithmInfo algInfo;
        PrivateRSAKeyAttributes prkAttr;
        int keyInfo;
        boolean advanced = true;
        PrivateKeyObject prk = (PrivateKeyObject)this.getCardInfo().getPkcs15Structure().getP15PrivateKeyObjectDirectory().getObject(certificateInfo.getCertObjId());
        if (prk != null && (keyInfo = (prkAttr = (PrivateRSAKeyAttributes)prk.getKeyAttributes()).getKeyInfo().getReference()) != -1 && (algInfo = this.getCardInfo().getPkcs15Structure().getP15TokenInfo().getSupportedAlgorithm(keyInfo)) != null) {
            int algRef = algInfo.getAlgRef();
            advanced = algRef > 0 && (algRef & 0x80) == 0;
        }
        return advanced;
    }
}

