/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.signtrust.g3;

import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.util.Iterator;

public class CardProduct
extends CiCardProduct {
    public static final int KEYD_QSIG_RECORD_NUMBER = 1;
    public static final CardFilePath EF_KEYD = new CardFilePath("0013");

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        try {
            IPinInfo pinInfo = this.getCardInfo().lookupPinInfo("PIN.CH.QES1");
            int index = Integer.parseInt(pinInfo.lookupProperty("keyd_index"));
            IFileSystemApplication fileSystem = (IFileSystemApplication)this.createCardApplication(connection, IFileSystemApplication.class);
            fileSystem.selectDf(pinInfo.getDirectory(), false);
            byte[] bytes = fileSystem.readRecord((CardFileSelector)EF_KEYD, index);
            if (bytes != null) {
                TlvTemplate template = Iso7816BerElement.parseTemplate((byte[])bytes, (int)0, (int)bytes.length);
                Iterator securityMechanisms = template.iteratorTagged(123);
                while (securityMechanisms.hasNext()) {
                    byte[] content;
                    TlvElement ssec;
                    TlvElement securityMechanism = (TlvElement)securityMechanisms.next();
                    TlvElement crte = securityMechanism.getTemplate().getElementTagged(164);
                    if (crte == null || (ssec = crte.getTemplate().getElementTagged(40738)) == null || (content = ssec.getValue()) == null || content.length <= 0) continue;
                    return content[0];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }
}

