/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.signtrust.g3;

import de.intarsys.security.smartcard.app.common.AbstractCardStateApp;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.v32.Starcos32Tools;
import de.intarsys.tools.hex.HexTools;
import jakarta.annotation.PostConstruct;

public class CardStateApp
extends AbstractCardStateApp {
    private int qSigRestriction;

    public String getLabel() {
        switch (this.qSigRestriction) {
            case 1: {
                return "Signtrust Card";
            }
            case 100: {
                return "Signtrust M-Card 100";
            }
        }
        return "Signtrust M-Card";
    }

    public int getqSigRestriction() {
        return this.qSigRestriction;
    }

    public String getSerialNumber() throws CardApplicationException {
        byte[] serial = Starcos32Tools.getSerialNumber(this.getCardProduct(), this.getCardConnection());
        if (serial.length > 0) {
            return HexTools.bytesToHexString((byte[])serial);
        }
        return "00";
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.qSigRestriction = this.getCardProduct().getQSigRestriction(this.getCardConnection());
    }

    public void setqSigRestriction(int qSigRestriction) {
        this.qSigRestriction = qSigRestriction;
    }
}

