/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.signtrust.g3;

import de.intarsys.security.smartcard.app.common.AbstractPinStateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateActive;
import de.intarsys.security.smartcard.common.PinStateInactive;
import de.intarsys.security.smartcard.common.PinStateLocked;
import de.intarsys.security.smartcard.common.PinStateNotAvailable;
import de.intarsys.security.smartcard.common.PinStateTransport;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;

public class PinStateApp
extends AbstractPinStateApp {
    public static final CardFilePath EF_KEYD = new CardFilePath("0013");

    public PinState getPinState(IPinInfo pinInfo) throws CardApplicationException {
        try {
            this.getFileSystem().selectDf(pinInfo.getDirectory(), false);
        }
        catch (Exception e) {
            return new PinStateNotAvailable(pinInfo);
        }
        try {
            byte[] content;
            TlvTemplate template;
            TlvElement lcs;
            int index = Integer.parseInt(pinInfo.lookupProperty("keyd_index"));
            byte[] bytes = this.getFileSystem().readRecord((CardFileSelector)EF_KEYD, index);
            if (bytes != null && (lcs = (template = Iso7816BerElement.parseTemplate((byte[])bytes, (int)0, (int)bytes.length)).getElementTagged(138)) != null && (content = lcs.getValue()) != null && content.length > 0 && content[0] == 35) {
                return new PinStateTransport(pinInfo);
            }
        }
        catch (Exception index) {
            // empty catch block
        }
        ResponseAPDU resp = this.cmdVerify(pinInfo);
        int sw1 = resp.getSw1();
        int sw2 = resp.getSw2();
        if (sw1 == 105 && sw2 == 131) {
            return new PinStateLocked(pinInfo);
        }
        if (sw1 == 105 && sw2 == 132) {
            return new PinStateInactive(pinInfo);
        }
        if (sw1 == 99 && (sw2 & 0xF0) == 192) {
            int counter = sw2 & 0xF;
            if (counter == 0) {
                return new PinStateLocked(pinInfo);
            }
            return new PinStateActive(pinInfo, counter);
        }
        return new PinStateUnknown(pinInfo);
    }
}

