/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.strust;

import de.intarsys.security.smartcard.app.common.AbstractCardStateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.IOException;

public class CardStateApp
extends AbstractCardStateApp {
    private static final CardFilePath EF_GDO = new CardFilePath(":3F00:2F02");
    private int qSigRestriction;

    public String getLabel() throws CardApplicationException {
        if (this.qSigRestriction == 1) {
            return "S-TRUST Karte";
        }
        return "S-TRUST Massensignaturkarte";
    }

    public int getqSigRestriction() {
        return this.qSigRestriction;
    }

    public String getSerialNumber() throws CardApplicationException {
        try {
            Iso7816BerElement element;
            byte[] gdo = this.getFileSystem().readBinaryCached((CardFileSelector)EF_GDO);
            if (gdo.length > 2 && (element = Iso7816BerElement.parseElement((byte[])gdo, (int)0, (int)gdo.length)) != null) {
                byte[] serialNumber = element.getValue();
                return HexTools.bytesToHexString((byte[])serialNumber);
            }
        }
        catch (CardFileNotFoundException gdo) {
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
        return "00";
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.qSigRestriction = this.getCardProduct().getQSigRestriction(this.getCardConnection());
    }

    public boolean matchSerialNumber(String printedNumber) throws CardApplicationException {
        if (StringTools.isEmpty((String)printedNumber)) {
            return false;
        }
        String cardSerial = this.getSerialNumber();
        if (cardSerial.equals(printedNumber)) {
            return true;
        }
        if (cardSerial.length() == 20) {
            String partial = cardSerial.substring(8, 18);
            return partial.equals(printedNumber);
        }
        return false;
    }

    public void setqSigRestriction(int qSigRestriction) {
        this.qSigRestriction = qSigRestriction;
    }
}

