/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.strust;

import de.intarsys.security.smartcard.app.common.AbstractPinStateApp;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateActive;
import de.intarsys.security.smartcard.common.PinStateLocked;
import de.intarsys.security.smartcard.common.PinStateTransport;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.starcos.v32.Starcos32Tools;

public class PinStateApp
extends AbstractPinStateApp {
    public PinState getPinState(IPinInfo pinInfo) throws CardApplicationException {
        if (Starcos32Tools.isTransportPinActive(this.getCardProduct(), this.getCardConnection(), pinInfo)) {
            return new PinStateTransport(pinInfo);
        }
        try {
            int retries = Starcos32Tools.getKFPC(this.getCardProduct(), this.getCardConnection(), pinInfo);
            if (retries == 0) {
                return new PinStateLocked(pinInfo);
            }
            return new PinStateActive(pinInfo, retries, false);
        }
        catch (Exception e) {
            return new PinStateUnknown(pinInfo, false);
        }
    }
}

