/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.strust;

import de.intarsys.security.smartcard.app.common.AbstractSignApp;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardStatusCodeException;
import de.intarsys.security.smartcard.product.strust.PACKAGE;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.message.IMessageBundle;
import jakarta.annotation.PostConstruct;

public class QSignApp
extends AbstractSignApp
implements IQSignApplication {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        IDigest digest = this.parseDigest(data);
        int digestAlgoRef = this.getDigestAlgoRef(digest.getAlgorithmName());
        try {
            this.cmdMseSetComponentAlgoRef(170, digestAlgoRef);
        }
        catch (CardStatusCodeException e) {
            if (digestAlgoRef == 64 && e.getSw1() == 106 && e.getSw2() == 128) {
                String msg = Msg.getString("QSignApp.errorSHA256NotSupported", new Object[0]);
                throw new CardApplicationException(msg);
            }
            throw e;
        }
        this.cmdPsoHashUpload(digest.getBytes());
        this.cmdMseSetComponentKeyAlgoRef(182, this.getCardHolderCertificate().getPrivateKeyInfo().getReference(), this.getSignatureAlgoRef(digest.getAlgorithmName()));
        return this.cmdPsoComputeDigitalSignature(null).getData();
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IQSignApplication.class;
    }

    public int getDigestAlgoRef(String algorithmName) throws CardApplicationException {
        if ("SHA-1".equals(algorithmName)) {
            return 16;
        }
        if ("RIPEMD160".equals(algorithmName)) {
            return 32;
        }
        if ("SHA-256".equals(algorithmName)) {
            return 64;
        }
        throw new CardApplicationException("Unsupported digest algorithm");
    }

    public int getSignatureAlgoRef(String algorithmName) {
        if ("SHA-1".equals(algorithmName)) {
            return 18;
        }
        if ("SHA-256".equals(algorithmName)) {
            return 66;
        }
        if ("RIPEMD160".equals(algorithmName)) {
            return 33;
        }
        return -1;
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setRestrictionCount(this.getCardProduct().getQSigRestriction(this.getCardConnection()));
    }
}

