/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.swisscom;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.PinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pkcs15.AlgorithmInfo;
import de.intarsys.security.smartcard.pkcs15.ObjectDirectory;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.security.smartcard.pkcs15.PrivateKeyObject;
import de.intarsys.security.smartcard.pkcs15.PrivateRSAKeyAttributes;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;

public class CardProduct
extends Pkcs15CardProduct {
    @Override
    public void accepted(ICardProductFactory factory, ICardConnection connection) throws CardApplicationException {
        super.accepted(factory, connection);
        for (IPinInfo info : this.getCardInfo().getPinInfos()) {
            ((PinInfo)info).setTransportLength(5);
        }
    }

    protected int createQSigRestriction(ICardConnection connection) throws CardApplicationException {
        return this.getQSigRestriction(this.getCardInfo().getPkcs15Structure());
    }

    protected int getQSigPrivateKeyInfoRef(Pkcs15Structure cardInfo) {
        ObjectDirectory privateKeyDir = cardInfo.getP15PrivateKeyObjectDirectory();
        for (int i = 0; i < privateKeyDir.size(); ++i) {
            PrivateKeyObject prKeyObject = (PrivateKeyObject)privateKeyDir.getObject(i);
            if (!prKeyObject.getUsage().isNonRepudiation()) continue;
            return ((PrivateRSAKeyAttributes)prKeyObject.getKeyAttributes()).getKeyInfo().getReference();
        }
        return -1;
    }

    protected int getQSigRestriction(Pkcs15Structure pkcs15) {
        String label = pkcs15.getP15TokenInfo().getLabel();
        if (label.toLowerCase().contains("enterprise")) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean isDSIFileUsed() {
        Pkcs15Structure pkcs15 = this.getCardInfo().getPkcs15Structure();
        int keyInfoRef = this.getQSigPrivateKeyInfoRef(pkcs15);
        AlgorithmInfo algorithmInfo = pkcs15.getP15TokenInfo().getSupportedAlgorithm(keyInfoRef);
        if (algorithmInfo != null) {
            return "1.2.840.113549.1.1.5".equals(algorithmInfo.getAlgId());
        }
        return false;
    }
}

