/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.telesec.common;

import de.intarsys.security.smartcard.model.CardHolderCertificate;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesArgs;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.servicelocator.ServiceLocator;
import jakarta.annotation.PostConstruct;
import javax.security.auth.x500.X500Principal;

@SingletonProvider
public class TelesecEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    public static final String ARG_SHOWPLACEHOLDER = "showPlaceholder";
    private static final String PREF_SHOWPLACEHOLDER = "showPlaceholder";
    private boolean showPlaceholderCertificate = false;
    private IPreferences preferences;

    public static TelesecEnvironment get() {
        return (TelesecEnvironment)ServiceLocator.get().get(TelesecEnvironment.class);
    }

    public void configure(IArgs args) {
        this.setShowPlaceholderCertificate(ArgTools.getBoolStrict((IArgs)args, (String)"showPlaceholder", (boolean)this.isShowPlaceholderCertificate()));
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.smartcard/product/telesec";
    }

    @PostConstruct
    public void install() {
        this.preferencesRestore();
    }

    public boolean isPlaceholderCertificate(CardHolderCertificate cert) {
        if (cert == null) {
            return false;
        }
        X500Principal principal = cert.getIssuerX500Principal();
        if (principal != null) {
            String name = principal.toString().toLowerCase();
            return name.indexOf("tks ca") >= 0 || name.indexOf("nks ca") >= 0;
        }
        return false;
    }

    public boolean isShowCertificate(CardHolderCertificate certificate) {
        return this.showPlaceholderCertificate || !this.isPlaceholderCertificate(certificate);
    }

    public boolean isShowPlaceholderCertificate() {
        return this.showPlaceholderCertificate;
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.put("showPlaceholder", false);
    }

    public void preferencesRestore() {
        this.configure((IArgs)new PreferencesArgs(this.getPreferences()));
    }

    public void preferencesStore() {
    }

    public void setShowPlaceholderCertificate(boolean showPlaceholder) {
        this.showPlaceholderCertificate = showPlaceholder;
    }
}

