/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.telesec.v20;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.dataobject.ApplicationTemplate;
import de.intarsys.security.smartcard.iso.dataobject.EFDir;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.tools.collection.IterableTools;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.util.Iterator;

public class CardProduct
extends CiCardProduct {
    protected int createQSigRestriction(ICardConnection connection) {
        try {
            IFileSystemApplication fileSystem = (IFileSystemApplication)this.createCardApplication(connection, IFileSystemApplication.class);
            CardFileSelector selector = this.getCardInfo().lookupFileSelector("EF.DIR");
            byte[] bytes = fileSystem.readBinary(selector);
            TlvTemplate tpl = Iso7816BerElement.parseTemplate((byte[])bytes, (int)0, (int)bytes.length);
            EFDir efDir = new EFDir(tpl);
            for (ApplicationTemplate applicationTemplate : IterableTools.in((Iterator)efDir.getApplicationTemplates())) {
                String label = applicationTemplate.getApplicationLabel();
                if (label == null || !label.startsWith("ESIGN") || !label.endsWith("-M")) continue;
                return -1;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }
}

