/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.telesec.v20;

import de.intarsys.security.smartcard.app.common.AbstractCardStateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerElement;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.IOException;

public class CardStateApp
extends AbstractCardStateApp {
    private static final CardFilePath EF_GDO = new CardFilePath("3F00:2F02");
    private int qSigRestriction;

    public String getLabel() {
        if (this.qSigRestriction == 1) {
            return "TeleSec NetKey 3.0";
        }
        return "TeleSec NetKey 3.0 M";
    }

    public int getqSigRestriction() {
        return this.qSigRestriction;
    }

    public String getSerialNumber() throws CardApplicationException {
        try {
            Iso7816BerElement element;
            byte[] gdo = this.getFileSystem().readBinaryCached((CardFileSelector)EF_GDO);
            if (gdo.length > 2 && (element = Iso7816BerElement.parseElement((byte[])gdo, (int)0, (int)gdo.length)) != null) {
                byte[] serialNumber = element.getValue();
                String hexSerial = HexTools.bytesToHexString((byte[])serialNumber);
                if (hexSerial.charAt(hexSerial.length() - 1) == '0') {
                    hexSerial = hexSerial.substring(0, hexSerial.length() - 1);
                }
                return hexSerial;
            }
        }
        catch (CardFileNotFoundException gdo) {
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
        return "00";
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.qSigRestriction = this.getCardProduct().getQSigRestriction(this.getCardConnection());
    }

    public boolean matchSerialNumber(String printedNumber) throws CardApplicationException {
        if (StringTools.isEmpty((String)printedNumber)) {
            return false;
        }
        String cardSerial = this.getSerialNumber();
        if (cardSerial.equals(printedNumber)) {
            return true;
        }
        if (cardSerial.equals(printedNumber + "0")) {
            return true;
        }
        return printedNumber.equals(cardSerial + "0");
    }

    public void setqSigRestriction(int qSigRestriction) {
        this.qSigRestriction = qSigRestriction;
    }
}

