/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.telesec.v20;

import de.intarsys.security.smartcard.app.common.AbstractPinStateApp;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.DelegatePinState;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateActive;
import de.intarsys.security.smartcard.common.PinStateInactive;
import de.intarsys.security.smartcard.common.PinStateLocked;
import de.intarsys.security.smartcard.common.PinStateNotAvailable;
import de.intarsys.security.smartcard.common.PinStateTransport;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;

public class PinStateApp
extends AbstractPinStateApp {
    private PinState basicGetPinState(IPinInfo pinInfo) throws CardApplicationException {
        ResponseAPDU resp = this.cmdVerify(pinInfo);
        int sw1 = resp.getSw1();
        int sw2 = resp.getSw2();
        if (sw1 == 105 && sw2 == 133) {
            return new PinStateTransport(pinInfo);
        }
        if (sw1 == 105 && sw2 == 131) {
            return new PinStateLocked(pinInfo);
        }
        if (sw1 == 105 && sw2 == 132) {
            return new PinStateInactive(pinInfo);
        }
        if (sw1 == 99 && (sw2 & 0xF0) == 192) {
            int counter = sw2 & 0xF;
            if (counter == 0) {
                return new PinStateLocked(pinInfo);
            }
            return new PinStateActive(pinInfo, counter);
        }
        return new PinStateUnknown(pinInfo);
    }

    public PinState getPinState(IPinInfo pinInfo) throws CardApplicationException {
        PinState resettingPinState;
        try {
            this.getFileSystem().selectDf(pinInfo.getDirectory(), false);
        }
        catch (Exception e) {
            return new PinStateNotAvailable(pinInfo);
        }
        PinState pinState = this.basicGetPinState(pinInfo);
        if (pinState.isResettable() && pinInfo.getResettingPinInfo() != null && (!(resettingPinState = this.basicGetPinState(pinInfo.getResettingPinInfo())).isVerifiable() || resettingPinState.getRetries() <= 0)) {
            return new DelegatePinState(pinState){

                public boolean isResettable() {
                    return false;
                }
            };
        }
        return pinState;
    }
}

