/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.uacard.v1;

import de.intarsys.security.smartcard.app.common.AbstractSignApp;
import de.intarsys.security.smartcard.app.common.IAdvSignApplication;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICommand;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.Mechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.os.jcop.JcopCmdSign;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;

public class AdvSignApp
extends AbstractSignApp
implements IAdvSignApplication {
    private static final List<String> DIGEST_ALGORITHMS = Arrays.asList("SHA-256", "SHA-384", "SHA-512");

    protected void basicResetFileSystem() throws CardApplicationException {
        try {
            CardFileSelector selector = this.getCardInfo().lookupFileSelector("DF.APP");
            this.getFileSystem().selectDf(selector, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void basicResetSecurityStateCard() {
    }

    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        IMechanism mechanism = this.detectMechanism();
        if (mechanism == null) {
            throw new CardApplicationException("no mechanism found for " + this.getHashAlgorithmName());
        }
        String encryptionAlgorithmName = this.getEncryptionAlgorithmName();
        if ("RSA".equals(encryptionAlgorithmName)) {
            return this.cmdSign(data, mechanism).getData();
        }
        throw new CardApplicationException("encryption algorithm " + encryptionAlgorithmName + " not supported");
    }

    protected ResponseAPDU cmdSign(byte[] data, IMechanism mechanism) throws CardApplicationException {
        JcopCmdSign pso = (JcopCmdSign)this.getCommand(JcopCmdSign.class);
        byte[] psoData = this.createPSOInput(data, mechanism);
        RequestAPDU req = pso.createSign(1, 64, psoData);
        return this.sendRequest((ICommand)pso, req);
    }

    protected IMechanism createDefaultMechanism() {
        String encryptionAlgorithmName = this.getEncryptionAlgorithmName();
        if ("RSA".equals(encryptionAlgorithmName)) {
            Mechanism tmpMech = new Mechanism("dst");
            tmpMech.setHashAlgorithmNames(DIGEST_ALGORITHMS);
            tmpMech.setOperation("DST");
            tmpMech.setInputEncodingAlgorithmName("Raw");
            tmpMech.setOutputEncodingAlgorithmName("PSS");
            return tmpMech;
        }
        if ("ECDSA".equals(encryptionAlgorithmName)) {
            Mechanism tmpMech = new Mechanism("dst");
            tmpMech.setHashAlgorithmNames(DIGEST_ALGORITHMS);
            tmpMech.setOperation("DST");
            return tmpMech;
        }
        return null;
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IAdvSignApplication.class;
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setSupportedHashAlgorithmNames(DIGEST_ALGORITHMS);
        this.setHashAlgorithmName("SHA-512");
    }
}

