/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.uacard.v1;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.security.smartcard.app.common.AbstractCardStateApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tr3110.asn1.CardVerifiableCertificate;
import de.intarsys.tr3110.asn1.CertificateBody;
import de.intarsys.tr3110.asn1.CertificateReference;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardStateApp
extends AbstractCardStateApp {
    private static final Logger Log = LoggerFactory.getLogger(CardStateApp.class);

    public String getSerialNumber() throws CardApplicationException {
        String result = null;
        try {
            Log.debug("read cv certificates from uacard");
            CardFileSelector selector = this.getCardInfo().lookupFileSelector("DF.APP");
            this.getFileSystem().selectDf(selector, false);
            CardFileId devaut = new CardFileId(47, 2);
            byte[] data = this.getFileSystem().readBinary((CardFileSelector)devaut);
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            CardVerifiableCertificate cert = (CardVerifiableCertificate)ASN1BasedTools.create((ASN1Based.Factory)CardVerifiableCertificate.FACTORY, (InputStream)is);
            while (cert != null) {
                CertificateBody body = cert.getCertificateBody();
                CertificateReference car = body.getCertificationAuthorityReference();
                CertificateReference chr = body.getCertificateHolderReference();
                if (result == null) {
                    result = chr.toString();
                }
                Log.debug("car {} 0x{}", (Object)car, (Object)HexTools.bytesToHexString((byte[])car.getEncoded()));
                Log.debug("chr {} 0x{}", (Object)chr, (Object)HexTools.bytesToHexString((byte[])chr.getEncoded()));
                cert = (CardVerifiableCertificate)ASN1BasedTools.create((ASN1Based.Factory)CardVerifiableCertificate.FACTORY, (InputStream)is);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result == null ? "00" : result;
    }
}

