/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.yubico;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.iso.dataobject.AccessConditions;
import de.intarsys.security.smartcard.iso.tlv.Iso7816SimpleElement;
import de.intarsys.security.smartcard.model.cmd.AbstractCmd;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;

public class CmdCreateObject
extends AbstractCmd {
    public static final int CLA = 128;
    public static final int INS = 224;
    public static final byte KEY_TYPE_RSA = 81;
    public static final byte KEY_TYPE_ECDSA = 82;
    public static final byte KEY_TYPE_3DES = 83;

    public RequestAPDU createKeyObject(byte keyType, CardFileId file, AccessConditions accessConditions) {
        TlvTemplate template = new TlvTemplate();
        template.addElement((TlvElement)new Iso7816SimpleElement(130, keyType));
        template.addElement((TlvElement)new Iso7816SimpleElement(131, file.getBytes()));
        template.addElement(accessConditions.getElement());
        Iso7816SimpleElement elFcp = new Iso7816SimpleElement(98, template.getEncoded());
        RequestAPDU request = new RequestAPDU(128, 224, 0, 7, elFcp.getEncoded(), false);
        request.setLabel(this.getLabel());
        return request;
    }

    public int getCla() {
        return 128;
    }

    public Class getCommandType() {
        return CmdCreateObject.class;
    }

    public int getIns() {
        return 224;
    }

    public String getLabel() {
        return "yubico create object";
    }
}

