/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.product.yubico;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.smartcard.app.common.AbstractKeyManagementApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.iso.dataobject.AccessConditions;
import de.intarsys.security.smartcard.model.ICommand;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardStatusCodeException;
import de.intarsys.security.smartcard.model.cmd.ICmdCreate;
import de.intarsys.security.smartcard.model.cmd.ICmdPerformSecurityOperation;
import de.intarsys.security.smartcard.pkcs15.CertificateObjectX509;
import de.intarsys.security.smartcard.pkcs15.CommonObjectFlags;
import de.intarsys.security.smartcard.pkcs15.Identifier;
import de.intarsys.security.smartcard.pkcs15.IdentifierOctetString;
import de.intarsys.security.smartcard.pkcs15.KeyAccessFlags;
import de.intarsys.security.smartcard.pkcs15.KeyInfo;
import de.intarsys.security.smartcard.pkcs15.KeyUsageFlags;
import de.intarsys.security.smartcard.pkcs15.ObjectValue;
import de.intarsys.security.smartcard.pkcs15.Path;
import de.intarsys.security.smartcard.pkcs15.Pkcs15Structure;
import de.intarsys.security.smartcard.pkcs15.PrivateKeyObjectRSA;
import de.intarsys.security.smartcard.pkcs15.PublicKeyObjectRSA;
import de.intarsys.security.smartcard.pkcs15.ReferencedValue;
import de.intarsys.security.smartcard.product.pkcs15.Pkcs15CardProduct;
import de.intarsys.security.smartcard.product.yubico.CmdCreateObject;
import de.intarsys.security.smartcard.product.yubico.CmdGenerateKeyPair;
import de.intarsys.security.smartcard.product.yubico.CmdReadObject;
import de.intarsys.tools.collection.ByteArrayTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;

public class KeyManagementApp
extends AbstractKeyManagementApp {
    private PublicKey publicKey;
    private String tempPkcs15Id;
    private String tempPkcs15Label;

    private void cardGenerateKeyPair() throws CardApplicationException {
        CmdGenerateKeyPair cmd = (CmdGenerateKeyPair)this.getCommand(CmdGenerateKeyPair.class);
        RequestAPDU req = cmd.generateKeyPair(2048);
        this.sendRequest((ICommand)cmd, req);
    }

    private byte[] createCertificateRecord(String label, String id, CardFileId certificateFile) throws CardApplicationException {
        CertificateObjectX509 certObject = (CertificateObjectX509)CertificateObjectX509.FACTORY.createNew();
        certObject.getCommonObjectAttributes().setLabel(label);
        certObject.getCommonObjectAttributes().setFlags((CommonObjectFlags)CommonObjectFlags.FACTORY.create((ASN1Encodable)new DERBitString(new byte[]{64}, 6)));
        certObject.getCommonCertificateAttributes().setIdentifier((Identifier)IdentifierOctetString.FACTORY.create((ASN1Encodable)new DEROctetString(id.getBytes())));
        Path certPath = (Path)Path.FACTORY.createNew();
        certPath.setPathString(certificateFile.getBytes());
        ReferencedValue refValue = (ReferencedValue)ReferencedValue.FACTORY.createNew();
        refValue.setPath(certPath);
        ObjectValue value = (ObjectValue)ObjectValue.FACTORY.createNew();
        value.setIndirect(refValue);
        certObject.getX509CertificateAttributes().setValue(value);
        try {
            return certObject.toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
    }

    private void createKeyObject(CardFileId prKeyFile) throws CardApplicationException {
        int authRef = this.getAuthenticationPinInfo().getReference();
        AccessConditions accessConditions = new AccessConditions(AccessConditions.AC_ALWAYS, authRef, AccessConditions.AC_NEVER, AccessConditions.AC_NEVER, AccessConditions.AC_NEVER, authRef, AccessConditions.AC_NEVER, authRef, authRef, authRef);
        CmdCreateObject cmd = (CmdCreateObject)this.getCommand(CmdCreateObject.class);
        RequestAPDU req = cmd.createKeyObject((byte)81, prKeyFile, accessConditions);
        this.sendRequest((ICommand)cmd, req);
    }

    private byte[] createPrivateKeyRecord(String label, String id, CardFileId privateKeyFile) throws CardApplicationException {
        byte keyReference = privateKeyFile.getLowByte();
        PrivateKeyObjectRSA prKey = (PrivateKeyObjectRSA)PrivateKeyObjectRSA.FACTORY.createNew();
        prKey.getCommonObjectAttributes().setLabel(label);
        prKey.getCommonObjectAttributes().setFlags((CommonObjectFlags)CommonObjectFlags.FACTORY.create((ASN1Encodable)new DERBitString(new byte[]{-64}, 6)));
        prKey.getCommonObjectAttributes().setAuthId((Identifier)IdentifierOctetString.FACTORY.create((ASN1Encodable)new DEROctetString(new byte[]{1})));
        prKey.getCommonKeyAttributes().setIdentifier((Identifier)IdentifierOctetString.FACTORY.create((ASN1Encodable)new DEROctetString(id.getBytes())));
        prKey.getCommonKeyAttributes().setUsage((KeyUsageFlags)KeyUsageFlags.FACTORY.create((ASN1Encodable)new DERBitString(new byte[]{96, 0}, 7)));
        prKey.getCommonKeyAttributes().setAccessFlags((KeyAccessFlags)KeyAccessFlags.FACTORY.create((ASN1Encodable)new DERBitString(new byte[]{-112}, 3)));
        prKey.getCommonKeyAttributes().setKeyReference((int)keyReference);
        Path prKeyPath = (Path)Path.FACTORY.createNew();
        prKeyPath.setPathString(privateKeyFile.getBytes());
        ReferencedValue refValue = (ReferencedValue)ReferencedValue.FACTORY.createNew();
        refValue.setPath(prKeyPath);
        ObjectValue value = (ObjectValue)ObjectValue.FACTORY.createNew();
        value.setIndirect(refValue);
        prKey.getPrivateRSAKeyAttributes().setValue(value);
        prKey.getPrivateRSAKeyAttributes().setModulusLength(2048);
        try {
            return prKey.toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
    }

    private void createPublicFile(CardFileId file, int size) throws CardApplicationException {
        int authRef = this.getAuthenticationPinInfo().getReference();
        AccessConditions accessConditions = new AccessConditions(AccessConditions.AC_ALWAYS, authRef, authRef, AccessConditions.AC_NEVER, AccessConditions.AC_NEVER, authRef);
        ICmdCreate cmd = (ICmdCreate)this.getCommand(ICmdCreate.class);
        RequestAPDU req = cmd.createCreateFileTransparent(file, false, size, accessConditions);
        this.sendRequest((ICommand)cmd, req);
    }

    private byte[] createPublicKeyRecord(String label, String id, CardFileId publicKeyFile) throws CardApplicationException {
        PublicKeyObjectRSA puKey = (PublicKeyObjectRSA)PublicKeyObjectRSA.FACTORY.createNew();
        puKey.getCommonObjectAttributes().setLabel(label);
        puKey.getCommonObjectAttributes().setFlags((CommonObjectFlags)CommonObjectFlags.FACTORY.create((ASN1Encodable)new DERBitString(new byte[]{64}, 6)));
        puKey.getCommonKeyAttributes().setIdentifier((Identifier)IdentifierOctetString.FACTORY.create((ASN1Encodable)new DEROctetString(id.getBytes())));
        puKey.getCommonKeyAttributes().setUsage((KeyUsageFlags)KeyUsageFlags.FACTORY.create((ASN1Encodable)new DERBitString(new byte[]{-126, 0}, 7)));
        puKey.getCommonKeyAttributes().setNative(false);
        puKey.getCommonKeyAttributes().setKeyReference(33);
        Path puKeyPath = (Path)Path.FACTORY.createNew();
        puKeyPath.setPathString(publicKeyFile.getBytes());
        ReferencedValue refValue = (ReferencedValue)ReferencedValue.FACTORY.createNew();
        refValue.setPath(puKeyPath);
        ObjectValue value = (ObjectValue)ObjectValue.FACTORY.createNew();
        value.setIndirect(refValue);
        puKey.getPublicRSAKeyAttributes().setValue(value);
        KeyInfo keyInfo = (KeyInfo)KeyInfo.FACTORY.createNew();
        keyInfo.setReference(0);
        puKey.getPublicRSAKeyAttributes().setKeyInfo(keyInfo);
        puKey.getPublicRSAKeyAttributes().setModulusLength(2048);
        try {
            return puKey.toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw CardApplicationException.create((Throwable)e);
        }
    }

    public void generateKeyPair() throws CardApplicationException {
        int nextRecord = this.getPkcs15Structure().getP15PrivateKeyObjectDirectory().size() + 1;
        CardFileId privateKeyFile = new CardFileId(0, 32 + nextRecord);
        this.createKeyObject(privateKeyFile);
        this.cardGenerateKeyPair();
        byte[] publicKeyData = this.readPublicKeyObject();
        this.publicKey = this.toJavaPublicKey(publicKeyData);
        CardFileId publicKeyFile = this.writePublicKey(publicKeyData);
        this.tempPkcs15Id = Integer.toHexString(nextRecord);
        this.tempPkcs15Label = this.getLabelBaseName() + this.tempPkcs15Id;
        this.writePrivateKeyRecord(this.tempPkcs15Label, this.tempPkcs15Id, privateKeyFile);
        this.writePublicKeyRecord(this.tempPkcs15Label, this.tempPkcs15Id, publicKeyFile);
    }

    public String getLabelBaseName() {
        return "SignLive! CC cloud suite ";
    }

    private CardFileId getNextFileId(List<CardFileSelector> files, CardFileId fallback) {
        if (files.isEmpty()) {
            return fallback;
        }
        Collections.sort(files, new Comparator<CardFileSelector>(){

            @Override
            public int compare(CardFileSelector o1, CardFileSelector o2) {
                int f1 = ByteArrayTools.toLittleEndianInt((byte[])o1.getFilePath().getBytes(), (int)0, (int)2);
                int f2 = ByteArrayTools.toLittleEndianInt((byte[])o2.getFilePath().getBytes(), (int)0, (int)2);
                return Integer.compare(f1, f2);
            }
        });
        CardFileId lastFile = files.get(0).getFileId();
        return new CardFileId(lastFile.getHiByte(), (byte)(lastFile.getLowByte() + 1));
    }

    public IPinInfo getPinInfo() {
        Iterator itPinInfo = this.getCardInfo().getPinInfos().iterator();
        return (IPinInfo)itPinInfo.next();
    }

    public Pkcs15Structure getPkcs15Structure() {
        return ((Pkcs15CardProduct)this.getCardProduct()).getCardInfo().getPkcs15Structure();
    }

    public PublicKey getPublicKey() throws CardApplicationException {
        return this.publicKey;
    }

    private byte[] readPublicKeyObject() throws CardApplicationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        CmdReadObject cmd = (CmdReadObject)this.getCommand(CmdReadObject.class);
        RequestAPDU req = cmd.readObject(0);
        ResponseAPDU resp = this.sendRequest((ICommand)cmd, req);
        try {
            out.write(resp.getData());
            if (out.size() >= 255) {
                req = cmd.readObject(out.size());
                resp = this.sendRequest((ICommand)cmd, req);
                out.write(resp.getData());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public byte[] sign(byte[] message) throws CardApplicationException {
        ICmdPerformSecurityOperation pso = (ICmdPerformSecurityOperation)this.getCommand(ICmdPerformSecurityOperation.class);
        RequestAPDU req = pso.createComputeDigitalSignature(message);
        ResponseAPDU resp = this.sendRequest((ICommand)pso, req);
        return resp.getData();
    }

    private PublicKey toJavaPublicKey(byte[] publicKeyData) throws CardApplicationException {
        try {
            ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])publicKeyData);
            BigInteger modulus = ((ASN1Integer)seq.getObjectAt(0)).getPositiveValue();
            BigInteger exp = ((ASN1Integer)seq.getObjectAt(1)).getPositiveValue();
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePublic(new RSAPublicKeySpec(modulus, exp));
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw CardApplicationException.create((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void writeCertificate(IX509PublicKeyCertificate certificate) throws CardApplicationException {
        byte[] encodedCert;
        try {
            encodedCert = certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw CardApplicationException.create((Throwable)e);
        }
        CardFileId fileId = new CardFileId(84, 1);
        CardFileId certificateFile = this.getNextFileId(this.getPkcs15Structure().getCertificateFiles(), fileId);
        this.createPublicFile(certificateFile, encodedCert.length);
        this.getFileSystem().updateBinary((CardFileSelector)certificateFile, 0, encodedCert, 0, encodedCert.length);
        this.writeCertificateRecord(this.tempPkcs15Label, this.tempPkcs15Id, certificateFile);
    }

    private void writeCertificateRecord(String label, String id, CardFileId certificateFile) throws CardApplicationException {
        byte[] recordData = this.createCertificateRecord(label, id, certificateFile);
        CardFileSelector path = this.getPkcs15Structure().getP15CertificateObjectDirectory().getPath();
        int recordNumber = this.getPkcs15Structure().getP15CertificateObjectDirectory().size() + 1;
        try {
            this.getFileSystem().updateRecord(path, recordNumber, recordData);
        }
        catch (CardStatusCodeException e) {
            if (e.getSw() == 27267) {
                this.getFileSystem().appendRecord(path, recordData);
            }
            throw e;
        }
    }

    private void writePrivateKeyRecord(String label, String id, CardFileId privateKeyFile) throws CardApplicationException {
        byte[] recordData = this.createPrivateKeyRecord(label, id, privateKeyFile);
        CardFileSelector path = this.getPkcs15Structure().getP15PrivateKeyObjectDirectory().getPath();
        int recordNumber = this.getPkcs15Structure().getP15PrivateKeyObjectDirectory().size() + 1;
        try {
            this.getFileSystem().updateRecord(path, recordNumber, recordData);
        }
        catch (CardStatusCodeException e) {
            if (e.getSw() == 27267) {
                this.getFileSystem().appendRecord(path, recordData);
            }
            throw e;
        }
    }

    private CardFileId writePublicKey(byte[] publicKey) throws CardApplicationException {
        CardFileId publicKeyFile = this.getNextFileId(this.getPkcs15Structure().getPublicKeyFiles(), new CardFileId(0, 65));
        this.createPublicFile(publicKeyFile, publicKey.length);
        this.getFileSystem().updateBinary((CardFileSelector)publicKeyFile, 0, publicKey, 0, publicKey.length);
        return publicKeyFile;
    }

    private void writePublicKeyRecord(String label, String id, CardFileId publicKeyFile) throws CardApplicationException {
        byte[] recordData = this.createPublicKeyRecord(label, id, publicKeyFile);
        CardFileSelector path = this.getPkcs15Structure().getP15PublicKeyObjectDirectory().getPath();
        int recordNumber = this.getPkcs15Structure().getP15PublicKeyObjectDirectory().size() + 1;
        try {
            this.getFileSystem().updateRecord(path, recordNumber, recordData);
        }
        catch (CardStatusCodeException e) {
            if (e.getSw() == 27267) {
                this.getFileSystem().appendRecord(path, recordData);
            }
            throw e;
        }
    }
}

