/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.ssl.SslTools;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class HttpConfiguration {
    public static final String ARG_SSL_CONTEXT = "sslContext";
    public static final String ARG_HOSTNAME_VERIFIER = "hostnameVerifier";
    public static final String ARG_CONNECT_TIMEOUT = "connectTimeout";
    public static final String ARG_READ_TIMEOUT = "readTimeout";
    public static final String ARG_USE_PROXY = "useProxy";
    private static final long DEFAULT_CONNECT_TIMEOUT = 0L;
    private static final long DEFAULT_READ_TIMEOUT = 0L;
    private static final boolean DEFAULT_USE_PROXY = false;
    private SSLContext sslContext;
    private HostnameVerifier hostnameVerifier;
    private long connectTimeout;
    private long readTimeout;
    private boolean useProxy;

    public static Builder builder() {
        return new Builder();
    }

    public static HttpConfiguration from(IArgs args) {
        if (args == null) {
            return new HttpConfiguration();
        }
        SSLContext sslContext = SslTools.getSslContext((IArgs)args, (String)ARG_SSL_CONTEXT);
        HostnameVerifier hostnameVerifier = (HostnameVerifier)ArgTools.getValue((IArgs)args, (String)ARG_HOSTNAME_VERIFIER, HostnameVerifier.class, null);
        int connectTimeout = ArgTools.getInt((IArgs)args, (String)ARG_CONNECT_TIMEOUT, (int)0);
        int readTimeout = ArgTools.getInt((IArgs)args, (String)ARG_CONNECT_TIMEOUT, (int)0);
        boolean useProxy = ArgTools.getBoolean((IArgs)args, (String)ARG_USE_PROXY, (boolean)false);
        return new HttpConfiguration(sslContext, hostnameVerifier, connectTimeout, readTimeout, useProxy);
    }

    public static HttpConfiguration from(IArgs args, String path) {
        Object value = ArgTools.getPath((IArgs)args, (String)path);
        if (value instanceof HttpConfiguration) {
            HttpConfiguration httpConfiguration = (HttpConfiguration)value;
            return httpConfiguration;
        }
        return HttpConfiguration.from(ArgTools.toArgs((Object)value));
    }

    public HttpConfiguration() {
        this(null, null, 0L, 0L, false);
    }

    public HttpConfiguration(SSLContext sslContext, HostnameVerifier hostnameVerifier, long connectTimeout, long readTimeout, boolean useProxy) {
        this.sslContext = sslContext;
        this.hostnameVerifier = hostnameVerifier;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.useProxy = useProxy;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public IArgs toArgs() {
        Args args = Args.create();
        args.put(ARG_SSL_CONTEXT, (Object)this.sslContext);
        args.put(ARG_HOSTNAME_VERIFIER, (Object)this.hostnameVerifier);
        args.put(ARG_CONNECT_TIMEOUT, (Object)this.connectTimeout);
        args.put(ARG_READ_TIMEOUT, (Object)this.readTimeout);
        args.put(ARG_USE_PROXY, (Object)this.useProxy);
        return args;
    }

    public String toString() {
        return String.format("%s(sslContext=%s, hostnameVerifier=%s, connectTimeout=%d, readTimeout=%d, useProxy=%b)", this.getClass().getSimpleName(), this.sslContext == null ? "no" : "yes", this.hostnameVerifier == null ? "no" : "yes", this.connectTimeout, this.readTimeout, this.useProxy);
    }

    public static class Builder {
        private HttpConfiguration template = new HttpConfiguration();

        public HttpConfiguration build() {
            return new HttpConfiguration(this.template.sslContext, this.template.hostnameVerifier, this.template.connectTimeout, this.template.readTimeout, this.template.useProxy);
        }

        public Builder connectTimeout(long connectionTimeout) {
            this.template.connectTimeout = connectionTimeout;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.template.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder readTimeout(long readTimeout) {
            this.template.readTimeout = readTimeout;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.template.sslContext = sslContext;
            return this;
        }

        public Builder useProxy() {
            this.template.useProxy = true;
            return this;
        }
    }
}

