/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.upreg.BareBoneSigner;
import de.intarsys.security.device.upreg.PACKAGE;
import de.intarsys.security.device.upreg.UPRegSigner;
import de.intarsys.security.device.upreg.client.Hash;
import de.intarsys.security.device.upreg.client.HashAlgorithm;
import de.intarsys.security.device.upreg.client.Rt1GenerateRequest;
import de.intarsys.security.device.upreg.client.Rt1GenerateResponse;
import de.intarsys.security.device.upreg.client.Rt2SignRequest;
import de.intarsys.security.device.upreg.client.Rt2SignResponse;
import de.intarsys.security.device.upreg.client.UPRegServiceClient;
import de.intarsys.security.device.upreg.client.UPRegServiceException;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.message.IMessageBundle;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterizedUPRegSigner
extends BareBoneSigner {
    private static final IMessageBundle Messages = PACKAGE.Messages;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private UPRegSigner parent;
    private String name;
    private byte[] lastSignature;
    private IDigest signedDigest;
    private int signedRevision;
    private String zbToken;
    private boolean authorized;
    private IConversation<ISignatureData> conversation;
    private IConversation<Rt1GenerateResponse> whenAuthorized;

    public ParameterizedUPRegSigner(UPRegSigner parent, String name, byte[] lastSignature, IDigest signedDigest, int signedRevision) {
        this.parent = parent;
        this.name = name;
        this.lastSignature = lastSignature;
        this.signedDigest = signedDigest;
        this.signedRevision = signedRevision;
        this.conversation = new Conversation(this.toString());
        this.whenAuthorized = parent.whenAuthenticated().thenApply(nothing -> this.rt1Generate());
    }

    public void assignZbToken(String zbToken) {
        this.logger.trace("{}: useZbToken()", (Object)this);
        this.zbToken = zbToken;
    }

    public void fail(Throwable throwable) {
        this.conversation.completeExceptionally(throwable);
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.parent.getAlgorithmParameterSpec();
    }

    public int getApproximatedContainerSize() {
        return this.parent.getApproximatedContainerSize();
    }

    public IDevice getDevice() {
        return this.parent.getDevice();
    }

    public String getEncryptionAlgorithmName() {
        return this.parent.getEncryptionAlgorithmName();
    }

    public String getHashAlgorithmName() {
        return this.parent.getHashAlgorithmName();
    }

    public String getPreferredHashAlgorithmName() {
        return this.parent.getPreferredHashAlgorithmName();
    }

    private UPRegServiceClient getServiceClient() {
        return this.parent.getServiceClient();
    }

    public SignatureFormat getSignatureFormat() {
        return this.parent.getSignatureFormat();
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return this.parent.getSupportedHashAlgorithmNames();
    }

    private Rt1GenerateResponse rt1Generate() throws SecurityApplicationException {
        this.logger.trace("{}: rt1-generate()", (Object)this);
        if (this.zbToken == null) {
            throw new IllegalStateException("Not authenticated");
        }
        Rt1GenerateRequest request = new Rt1GenerateRequest(this.zbToken, this.toHash(this.signedDigest), this.lastSignature, this.signedRevision);
        try {
            Rt1GenerateResponse response = this.getServiceClient().rt1Generate(request);
            this.authorized = true;
            return response;
        }
        catch (UPRegServiceException exception) {
            throw new SecurityApplicationException(Messages.getString("UPRegSigner.rt1GenerateError", new Object[]{this.name}), (Throwable)exception);
        }
    }

    private ISignatureData rt2Sign(IToBeSignedData dataToBeSigned) throws SecurityApplicationException {
        this.logger.trace("{}: rt2-sign()", (Object)this);
        if (!this.authorized) {
            throw new IllegalStateException("Not authorized");
        }
        Rt2SignRequest request = new Rt2SignRequest(this.zbToken, this.toHash(dataToBeSigned.getDigest()), this.signedRevision + 1);
        try {
            Rt2SignResponse response = this.getServiceClient().rt2Sign(request);
            return SignatureData.create((byte[])response.getSignature());
        }
        catch (UPRegServiceException exception) {
            throw new SecurityApplicationException(Messages.getString("UPRegSigner.rt2SignError", new Object[]{this.name}), (Throwable)exception);
        }
    }

    @Override
    public IConversation<ISignatureData> sign(IToBeSignedData dataToBeSigned) {
        try {
            ISignatureData signature = this.rt2Sign(dataToBeSigned);
            this.conversation.complete((Object)signature);
        }
        catch (SecurityApplicationException | IllegalStateException exception) {
            this.conversation.completeExceptionally(exception);
        }
        return this.parent.commitIfNecessary().thenCompose(nothing -> this.conversation);
    }

    private Hash toHash(IDigest digest) {
        HashAlgorithm algorithm = HashAlgorithm.forName(digest.getAlgorithmName());
        byte[] value = digest.getBytes();
        return new Hash(algorithm, value);
    }

    public String toString() {
        return String.format("%s:%s", new Object[]{this.parent, this.name});
    }

    public IConversation<Rt1GenerateResponse> whenAuthorized() {
        return this.whenAuthorized;
    }

    public IConversation<ISignatureData> whenSigned() {
        return this.whenAuthorized.thenCompose(nothing -> this.conversation);
    }
}

