/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.util.JacksonFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.upreg.HttpConfiguration;
import de.intarsys.security.device.upreg.UPRegDeviceProvider;
import de.intarsys.security.device.upreg.client.UPRegServiceClient;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.ext.ContextResolver;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.logging.LoggingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPRegDevice
extends CommonDevice<UPRegDeviceProvider> {
    public static final String LICENSE_PRODUCT_ID = "de.intarsys.security.device.upreg";
    public static final String ARG_HTTP_CONFIGURATION = "httpConfiguration";
    public static final String ARG_SERVICE_URL = "serviceUrl";
    public static final String ARG_PROVIDER_ID = "providerId";
    public static final String ARG_CALLBACK_PORT = "callbackPort";
    private static final String DEFAULT_SERVICE_URL = "https://www.upreg.ch";
    private static final int DEFAULT_CALLBACK_PORT = -1;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HttpConfiguration httpConfiguration;
    private String serviceUrl;
    private String providerId;
    private Integer callbackPort;
    private UPRegServiceClient serviceClient;

    public UPRegDevice(UPRegDeviceProvider provider, String id) {
        super((CommonDeviceProvider)provider, id);
    }

    public void configure(IArgs args) throws Exception {
        super.configure(args);
        this.httpConfiguration = HttpConfiguration.from(args, ARG_HTTP_CONFIGURATION);
        this.serviceUrl = ArgTools.getString((IArgs)args, (String)ARG_SERVICE_URL, (String)DEFAULT_SERVICE_URL);
        this.providerId = ArgTools.getString((IArgs)args, (String)ARG_PROVIDER_ID, null);
        int port = ArgTools.getInt((IArgs)args, (String)ARG_CALLBACK_PORT, (int)-1);
        this.callbackPort = port > 0 ? Integer.valueOf(port) : null;
    }

    private Client createClient(HttpConfiguration configuration) {
        SSLContext sslContext;
        HostnameVerifier hostnameVerifier;
        LoggingFeature logging = new LoggingFeature(java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName()), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_TEXT, Integer.valueOf(8192));
        ContextResolver<ObjectMapper> objectMapperProvider = new ContextResolver<ObjectMapper>(){

            public ObjectMapper getContext(Class<?> type) {
                return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
            }
        };
        ClientBuilder builder = ClientBuilder.newBuilder().withConfig((Configuration)new ClientConfig().register((Object)logging).register((Object)objectMapperProvider).register(JacksonFeature.class)).connectTimeout(configuration.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(configuration.getReadTimeout(), TimeUnit.MILLISECONDS);
        if (configuration.isUseProxy()) {
            String proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost == null) {
                this.logger.error("Proxy enabled, but system property http.proxyHost is not set; continuing without proxy");
            } else {
                String proxyScheme = proxyHost.startsWith("http") ? "" : "http://";
                String proxyPort = System.getProperty("http.proxyPort");
                String proxyUri = proxyPort == null ? proxyScheme + proxyHost : proxyScheme + proxyHost + ":" + proxyPort;
                String proxyUser = System.getProperty("http.proxyUser");
                String proxyPassword = System.getProperty("http.proxyPassword");
                ((ClientBuilder)((ClientBuilder)((ClientBuilder)builder.property("jersey.config.client.proxy.uri", (Object)proxyUri)).property("jersey.config.client.proxy.username", (Object)proxyUser)).property("jersey.config.client.proxy.password", (Object)proxyPassword)).property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
            }
        }
        if ((hostnameVerifier = configuration.getHostnameVerifier()) != null) {
            builder.hostnameVerifier(hostnameVerifier);
        }
        if ((sslContext = configuration.getSslContext()) != null) {
            builder.sslContext(sslContext);
        }
        return builder.build();
    }

    public Integer getCallbackPort() {
        return this.callbackPort;
    }

    public String getProviderId() {
        return this.providerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPRegServiceClient getServiceClient() {
        Object object = this.lock;
        synchronized (object) {
            if (this.serviceClient == null) {
                WebTarget endpoint = this.createClient(this.httpConfiguration).target(this.serviceUrl);
                this.serviceClient = new UPRegServiceClient(endpoint);
            }
        }
        return this.serviceClient;
    }

    protected void logConfiguration() {
        super.logConfiguration();
        this.logger.info("  +-- httpConfiguration: {}", (Object)this.httpConfiguration);
        this.logger.info("  +-- serviceUrl: {}", (Object)this.serviceUrl);
        this.logger.info("  +-- providerId: {}", (Object)this.providerId);
        this.logger.info("  +-- callbackPort: {}", (Object)this.callbackPort);
    }
}

