/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.upreg;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.upreg.UPRegDevice;
import de.intarsys.security.device.upreg.UPRegSignerFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class UPRegDeviceProvider
extends CommonDeviceProvider<UPRegDevice> {
    protected UPRegDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        String id = this.getId(args);
        return new UPRegDevice(this, id);
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        UPRegSignerFactory signerApp = new UPRegSignerFactory();
        signerApp.setDeviceProvider(this);
        signerApp.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        signerApp.setType(ISigner.class);
        signerApp.setPolicy((IApplicationPolicy)new CommonSignerPolicy((CommonDeviceProvider)this));
        apps.add((IApplicationDescriptor)signerApp);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.upreg");
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

